/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel.reader.sheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import top.redscorpion.core.func.SerBiConsumer;
import top.redscorpion.poi.excel.cell.RsCell;
import top.redscorpion.poi.excel.cell.editors.CellEditor;
import top.redscorpion.poi.excel.reader.sheet.AbstractSheetReader;

public class WalkSheetReader
extends AbstractSheetReader<Void> {
    private final SerBiConsumer<Cell, Object> cellHandler;

    public WalkSheetReader(int startRowIndex, int endRowIndex, SerBiConsumer<Cell, Object> cellHandler) {
        super(startRowIndex, endRowIndex);
        this.cellHandler = cellHandler;
    }

    @Override
    public Void read(Sheet sheet) {
        int startRowIndex = Math.max(this.cellRangeAddress.getFirstRow(), sheet.getFirstRowNum());
        int endRowIndex = Math.min(this.cellRangeAddress.getLastRow(), sheet.getLastRowNum());
        CellEditor cellEditor = this.config.getCellEditor();
        for (int y = startRowIndex; y <= endRowIndex; ++y) {
            Row row = sheet.getRow(y);
            if (null == row) continue;
            short startColumnIndex = (short)Math.max(this.cellRangeAddress.getFirstColumn(), row.getFirstCellNum());
            short endColumnIndex = (short)Math.min(this.cellRangeAddress.getLastColumn(), row.getLastCellNum());
            for (short x = startColumnIndex; x < endColumnIndex; x = (short)(x + 1)) {
                Cell cell = RsCell.getCell(row, x);
                this.cellHandler.accept(cell, RsCell.getCellValue(cell, cellEditor));
            }
        }
        return null;
    }
}

