/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.log.engine.console;

import java.util.function.Function;
import top.redscorpion.core.lang.ansi.AbstractAnsiEncoder;
import top.redscorpion.core.lang.ansi.Ansi4BitColor;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsDate;
import top.redscorpion.core.util.RsString;
import top.redscorpion.log.engine.console.ConsoleLog;
import top.redscorpion.log.level.Level;

public class ConsoleColorLog
extends ConsoleLog {
    private static final long serialVersionUID = 1L;
    private static final Ansi4BitColor COLOR_CLASSNAME = Ansi4BitColor.CYAN;
    private static final Ansi4BitColor COLOR_TIME = Ansi4BitColor.WHITE;
    private static final Ansi4BitColor COLOR_NONE = Ansi4BitColor.DEFAULT;
    private static Function<Level, Ansi4BitColor> colorFactory = level -> {
        switch (level) {
            case DEBUG: 
            case INFO: {
                return Ansi4BitColor.GREEN;
            }
            case WARN: {
                return Ansi4BitColor.YELLOW;
            }
            case ERROR: {
                return Ansi4BitColor.RED;
            }
            case TRACE: {
                return Ansi4BitColor.MAGENTA;
            }
        }
        return COLOR_NONE;
    };

    public static void setColorFactory(Function<Level, Ansi4BitColor> colorFactory) {
        ConsoleColorLog.colorFactory = colorFactory;
    }

    public ConsoleColorLog(String name) {
        super(name);
    }

    public ConsoleColorLog(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public synchronized void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        String template = AbstractAnsiEncoder.encode(COLOR_TIME, "[%s]", colorFactory.apply(level), "[%-5s]%s", COLOR_CLASSNAME, "%-30s: ", COLOR_NONE, "%s%n");
        System.out.format(template, RsDate.formatNow(), level.name(), " - ", RsClass.getShortClassName(this.getName()), RsString.format(format, arguments));
    }
}

