/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.json;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import top.redscorpion.core.map.MapWrapper;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsString;
import top.redscorpion.json.JSONArray;
import top.redscorpion.json.JSONObject;
import top.redscorpion.json.JSONTokener;
import top.redscorpion.json.XML;

public class RsJson {
    private RsJson() {
        throw new IllegalStateException("Utility class");
    }

    public static JSONObject jsonObject() {
        return new JSONObject();
    }

    public static JSONObject jsonObject(JSONTokener x) {
        return new JSONObject(x);
    }

    public static JSONObject jsonObject(Map<?, ?> m) {
        return new JSONObject(m);
    }

    public static JSONObject jsonObject(Object bean) {
        return new JSONObject(bean);
    }

    public static JSONObject jsonObject(String source) {
        return new JSONObject(source);
    }

    public static JSONObject jsonObject(int initialCapacity) {
        return new JSONObject(initialCapacity);
    }

    public static JSONArray jsonArray() {
        return new JSONArray();
    }

    public static JSONArray jsonArray(JSONTokener x) {
        return new JSONArray(x);
    }

    public static JSONArray jsonArray(String source) {
        return new JSONArray(source);
    }

    public static JSONArray jsonArray(Collection<?> collection) {
        return new JSONArray(collection);
    }

    public static JSONArray jsonArray(Iterable<?> iter) {
        return new JSONArray(iter);
    }

    public static JSONArray jsonArray(Object array) {
        return new JSONArray(array);
    }

    public static JSONArray jsonArray(int initialCapacity) {
        return new JSONArray(initialCapacity);
    }

    public static JSONObject xmlToJsonObject(String xml) {
        return XML.toJSONObject(xml);
    }

    public static String toJsonString(Map<?, ?> source) {
        return new JSONObject(source).toString();
    }

    public static String toJsonString(Map<?, ?> source, int indentFactor) {
        return new JSONObject(source).toString(indentFactor);
    }

    public static String toJsonString(Collection<?> collection) {
        return new JSONArray(collection).toString();
    }

    public static String toJsonString(Collection<?> collection, int indentFactor) {
        return new JSONArray(collection).toString(indentFactor);
    }

    public static String toJsonString(Iterable<?> iter) {
        return new JSONArray(iter).toString();
    }

    public static String toJsonString(Iterable<?> iter, int indentFactor) {
        return new JSONArray(iter).toString(indentFactor);
    }

    public static String toJsonString(Object obj) {
        return RsJson.toJsonString(obj, 0);
    }

    public static String toJsonString(Object obj, int indentFactor) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof CharSequence) {
            String jsonStr = RsString.trim((CharSequence)obj);
            if (RsJson.isTypeJsonArray(jsonStr)) {
                return new JSONArray(jsonStr).toString(indentFactor);
            }
            if (RsJson.isTypeJsonObject(jsonStr)) {
                return new JSONObject(jsonStr).toString(indentFactor);
            }
            return jsonStr;
        }
        if (obj instanceof MapWrapper) {
            return new JSONObject(obj).toString(indentFactor);
        }
        if (obj instanceof Iterable || obj instanceof Iterator || RsArray.isArray(obj)) {
            return new JSONArray(obj).toString(indentFactor);
        }
        return new JSONObject(obj).toString(indentFactor);
    }

    public static String toXmlString(JSONObject jsonObject) {
        return XML.toString(jsonObject);
    }

    public static boolean isTypeJson(String str) {
        return RsJson.isTypeJsonObject(str) || RsJson.isTypeJsonArray(str);
    }

    public static boolean isTypeJsonObject(String str) {
        if (RsString.isBlank(str)) {
            return false;
        }
        return RsString.isWrap((CharSequence)RsString.trim(str), '{', '}');
    }

    public static boolean isTypeJsonArray(String str) {
        if (RsString.isBlank(str)) {
            return false;
        }
        return RsString.isWrap((CharSequence)RsString.trim(str), '[', ']');
    }
}

