/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.server;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.stream.LimitedInputStream;
import top.redscorpion.core.map.CaseInsensitiveMap;
import top.redscorpion.core.map.multi.ListValueMap;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsNet;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsUrlQuery;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.meta.Method;
import top.redscorpion.http.meta.RsContentType;
import top.redscorpion.http.multipart.MultipartFormData;
import top.redscorpion.http.multipart.UploadSetting;
import top.redscorpion.http.server.HttpServerBase;
import top.redscorpion.http.useragent.RsUserAgent;
import top.redscorpion.http.useragent.UserAgent;

public class HttpServerRequest
extends HttpServerBase {
    private Map<String, HttpCookie> cookieCache;
    private ListValueMap<String, String> paramsCache;
    private MultipartFormData multipartFormDataCache;
    private Charset charsetCache;
    private byte[] bodyCache;

    public HttpServerRequest(HttpExchange httpExchange) {
        super(httpExchange);
    }

    public String getMethod() {
        return this.httpExchange.getRequestMethod();
    }

    public boolean isGetMethod() {
        return Method.GET.name().equalsIgnoreCase(this.getMethod());
    }

    public boolean isPostMethod() {
        return Method.POST.name().equalsIgnoreCase(this.getMethod());
    }

    public URI getUri() {
        return this.httpExchange.getRequestURI();
    }

    public String getPath() {
        return this.getUri().getPath();
    }

    public String getQuery() {
        return this.getUri().getQuery();
    }

    public Headers getHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    public String getHeader(HeaderName headerNameKey) {
        return this.getHeader(headerNameKey.toString());
    }

    public String getHeader(String headerKey) {
        return this.getHeaders().getFirst(headerKey);
    }

    public String getHeader(String headerKey, Charset charset) {
        String header = this.getHeader(headerKey);
        if (null != header) {
            return RsCharset.convert(header, RsCharset.ISO_8859_1, charset);
        }
        return null;
    }

    public String getContentType() {
        return this.getHeader(HeaderName.CONTENT_TYPE);
    }

    public Charset getCharset() {
        if (null == this.charsetCache) {
            String contentType = this.getContentType();
            this.charsetCache = RsObject.defaultIfNull(RsContentType.getCharset(contentType), DEFAULT_CHARSET);
        }
        return this.charsetCache;
    }

    public String getUserAgentStr() {
        return this.getHeader(HeaderName.USER_AGENT);
    }

    public UserAgent getUserAgent() {
        return RsUserAgent.parse(this.getUserAgentStr());
    }

    public String getCookiesStr() {
        return this.getHeader(HeaderName.COOKIE);
    }

    public Collection<HttpCookie> getCookies() {
        return this.getCookieMap().values();
    }

    public Map<String, HttpCookie> getCookieMap() {
        if (null == this.cookieCache) {
            this.cookieCache = RsMap.view(RsMap.putAll(new CaseInsensitiveMap(), RsNet.parseCookies(this.getCookiesStr()), HttpCookie::getName));
        }
        return this.cookieCache;
    }

    public HttpCookie getCookie(String cookieName) {
        return this.getCookieMap().get(cookieName);
    }

    public boolean isMultipart() {
        if (!this.isPostMethod()) {
            return false;
        }
        String contentType = this.getContentType();
        if (RsString.isBlank(contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public String getBody() {
        return this.getBody(this.getCharset());
    }

    public String getBody(Charset charset) {
        return RsString.str(this.getBodyBytes(), charset);
    }

    public byte[] getBodyBytes() {
        if (null == this.bodyCache) {
            this.bodyCache = RsIo.readBytes(this.getBodyStream(), true);
        }
        return this.bodyCache;
    }

    public InputStream getBodyStream() {
        InputStream bodyStream = this.httpExchange.getRequestBody();
        String contentLengthStr = this.getHeader(HeaderName.CONTENT_LENGTH);
        long contentLength = 0L;
        if (RsString.isNotBlank(contentLengthStr)) {
            try {
                contentLength = Long.parseLong(contentLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (contentLength > 0L) {
            bodyStream = new LimitedInputStream(bodyStream, contentLength);
        }
        return bodyStream;
    }

    public String getParam(String name) {
        return (String)this.getParams().getValue(name, 0);
    }

    public Collection<String> getParams(String name) {
        return (Collection)this.getParams().get(name);
    }

    public ListValueMap<String, String> getParams() {
        if (null == this.paramsCache) {
            this.paramsCache = new ListValueMap();
            Charset charset = this.getCharset();
            String query = this.getQuery();
            if (RsString.isNotBlank(query)) {
                this.paramsCache.putAll((Map<String, String>)RsUrlQuery.decodeQueryList(query, charset));
            }
            if (this.isMultipart()) {
                this.paramsCache.putAll((Map<String, String>)this.getMultipart().getParamListMap());
            } else {
                String body = this.getBody();
                if (RsString.isNotBlank(body)) {
                    this.paramsCache.putAll((Map<String, String>)RsUrlQuery.decodeQueryList(body, charset));
                }
            }
        }
        return this.paramsCache;
    }

    public String getClientIp(String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (RsArray.isNotEmpty(otherHeaderNames)) {
            headers = RsArray.addAll(headers, otherHeaderNames);
        }
        return this.getClientIpByHeader(headers);
    }

    public String getClientIpByHeader(String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = this.getHeader(header);
            if (RsNet.isUnknown(ip)) continue;
            return RsNet.getMultistageReverseProxyIp(ip);
        }
        ip = this.httpExchange.getRemoteAddress().getHostName();
        return RsNet.getMultistageReverseProxyIp(ip);
    }

    public MultipartFormData getMultipart() throws IORuntimeException {
        if (null == this.multipartFormDataCache) {
            this.multipartFormDataCache = this.parseMultipart(new UploadSetting());
        }
        return this.multipartFormDataCache;
    }

    public MultipartFormData parseMultipart(UploadSetting uploadSetting) throws IORuntimeException {
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream(this.getBodyStream(), this.getCharset());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return formData;
    }
}

