/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.meta;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.map.CaseInsensitiveMap;
import top.redscorpion.core.net.url.UrlDecoder;
import top.redscorpion.core.net.url.UrlEncoder;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.meta.HeaderName;

public class RsHttpHeader {
    public static List<String> headerList(Map<String, List<String>> headers, String name) {
        if (RsString.isBlank(name)) {
            return null;
        }
        CaseInsensitiveMap<String, List<String>> headersIgnoreCase = new CaseInsensitiveMap<String, List<String>>(headers);
        return (List)headersIgnoreCase.get(name.trim());
    }

    public static String createAttachmentDisposition(String fileName, Charset charset) {
        String encodeText = UrlEncoder.encodeAll(fileName, charset);
        return RsString.format("attachment;filename=\"{}\";filename*={}''{}", encodeText, charset.name(), encodeText);
    }

    public static String getFileNameFromDisposition(Map<String, List<String>> headers, String paramName) {
        paramName = RsObject.defaultIfNull(paramName, "filename");
        List<String> dispositions = RsHttpHeader.headerList(headers, HeaderName.CONTENT_DISPOSITION.getValue());
        String fileName = null;
        if (RsColl.isNotEmpty(dispositions) && !RsString.endWith((CharSequence)(fileName = RsHttpHeader.getFileNameFromDispositions(dispositions, RsString.addSuffixIfNot(paramName, "*"))), "*") && RsString.isBlank(fileName)) {
            fileName = RsHttpHeader.getFileNameFromDispositions(dispositions, paramName);
        }
        return fileName;
    }

    private static String getFileNameFromDispositions(List<String> dispositions, String paramName) {
        paramName = RsString.replace(paramName, "*", "\\*");
        String fileName = null;
        for (String disposition : dispositions) {
            fileName = RsRegular.getGroup1(paramName + "\\s*=\\s*([^;]+)", (CharSequence)disposition);
            if (!RsString.isNotBlank(fileName)) continue;
            break;
        }
        return RsHttpHeader.getRfc5987Value(fileName);
    }

    private static String getRfc5987Value(String value) {
        return ExtendedValue.of(value).getDecodeValue();
    }

    public static class ExtendedValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Charset charset;
        private String language;
        private final String value;

        public static ExtendedValue of(String value) {
            return new ExtendedValue(value);
        }

        public ExtendedValue(String value) {
            List<String> split = RsSplit.split(value, "'");
            if (3 == split.size()) {
                this.charset = RsCharset.charset(split.get(0));
                this.language = split.get(1);
                this.value = split.get(2);
            } else {
                this.value = RsString.unWrap(value, '\"');
            }
        }

        public Charset getCharset() {
            return this.charset;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getValue() {
            return this.value;
        }

        public String getDecodeValue() {
            return UrlDecoder.decodeForPath(this.value, this.charset);
        }
    }
}

