/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.okhttp;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.cookie.InMemoryCookieStore;
import top.redscorpion.http.client.engine.AbstractClientEngine;
import top.redscorpion.http.client.engine.okhttp.BasicProxyAuthenticator;
import top.redscorpion.http.client.engine.okhttp.CookieJarImpl;
import top.redscorpion.http.client.engine.okhttp.OkHttpClientConfig;
import top.redscorpion.http.client.engine.okhttp.OkHttpRequestBody;
import top.redscorpion.http.client.engine.okhttp.OkHttpResponse;
import top.redscorpion.http.proxy.HttpProxy;
import top.redscorpion.http.ssl.SSLInfo;

public class OkHttpEngine
extends AbstractClientEngine {
    private OkHttpClient client;

    public OkHttpEngine() {
        Assert.notNull(OkHttpClient.class);
    }

    @Override
    public OkHttpEngine init(ClientConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public Response send(Request message) {
        okhttp3.Response response;
        this.initEngine();
        try {
            response = this.client.newCall(OkHttpEngine.buildRequest(message)).execute();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return new OkHttpResponse(response, message);
    }

    @Override
    public Object getRawEngine() {
        return this.client;
    }

    @Override
    public void close() {
    }

    @Override
    protected void reset() {
        this.client = null;
    }

    @Override
    protected void initEngine() {
        int readTimeout;
        int connectionTimeout;
        if (null != this.client) {
            return;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ClientConfig config = RsObject.defaultIfNull(this.config, ClientConfig::of);
        SSLInfo sslInfo = config.getSslInfo();
        if (null != sslInfo) {
            SSLSocketFactory socketFactory = sslInfo.getSocketFactory();
            X509TrustManager trustManager = sslInfo.getTrustManager();
            if (null != socketFactory && null != trustManager) {
                builder.sslSocketFactory(socketFactory, trustManager);
            }
        }
        if ((connectionTimeout = config.getConnectionTimeout()) > 0) {
            builder.connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = config.getReadTimeout()) > 0) {
            builder.readTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS);
        }
        if (config instanceof OkHttpClientConfig) {
            builder.connectionPool(((OkHttpClientConfig)config).getConnectionPool());
        }
        builder.followRedirects(config.isFollowRedirects());
        OkHttpEngine.setProxy(builder, config);
        if (null != this.config && this.config.isUseCookieManager()) {
            this.cookieStore = new InMemoryCookieStore();
            builder.cookieJar((CookieJar)new CookieJarImpl(this.cookieStore));
        }
        this.client = builder.build();
    }

    private static okhttp3.Request buildRequest(Request message) {
        Request.Builder builder = new Request.Builder().url(message.handledUrl().toUrl());
        String method = message.method().name();
        HttpBody body = message.handledBody();
        if (null != body) {
            builder.method(method, (RequestBody)new OkHttpRequestBody(body));
        } else {
            builder.method(method, null);
        }
        message.headers().forEach((key, values) -> values.forEach(value -> builder.addHeader(key, value)));
        return builder.build();
    }

    private static void setProxy(OkHttpClient.Builder builder, ClientConfig config) {
        HttpProxy proxy = config.getProxy();
        if (null != proxy) {
            builder.setProxy$okhttp((Proxy)proxy);
            PasswordAuthentication auth = proxy.getAuth();
            if (null != auth) {
                builder.setProxyAuthenticator$okhttp((Authenticator)new BasicProxyAuthenticator(auth));
            }
        }
    }
}

