/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.cookie;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.client.cookie.CookieSpi;
import top.redscorpion.http.client.cookie.CookieStoreSpi;
import top.redscorpion.log.Log;

public class InMemoryCookieStore
implements CookieStoreSpi {
    private static final Log LOG = Log.get();
    private final Map<String, ConcurrentHashMap<String, CookieSpi>> cookies = new ConcurrentHashMap<String, ConcurrentHashMap<String, CookieSpi>>();

    @Override
    public List<URI> getURIs() {
        Set<String> keySet = this.cookies.keySet();
        ArrayList<URI> uris = new ArrayList<URI>(keySet.size());
        try {
            for (String hostKey : keySet) {
                uris.add(new URI("http", hostKey, null, null));
            }
        }
        catch (URISyntaxException e) {
            throw new HttpException(e);
        }
        return uris;
    }

    @Override
    public void add(URI httpUrl, CookieSpi cookie) {
        if (null == cookie || !cookie.isPersistent() || cookie.isExpired()) {
            return;
        }
        String hostKey = httpUrl.getHost();
        this.cookies.computeIfAbsent(hostKey, k -> new ConcurrentHashMap());
        String cookieKey = this.cookieKey(cookie);
        LOG.debug("Add cookie {}: {}", cookieKey, cookie);
        this.cookies.get(hostKey).put(cookieKey, cookie);
    }

    @Override
    public List<CookieSpi> get(URI httpUrl) {
        String hostKey = httpUrl.getHost();
        List<CookieSpi> result = this.get(httpUrl.getHost());
        LOG.debug("Get cookies {}: {}", hostKey, result);
        return result;
    }

    @Override
    public List<CookieSpi> getCookies() {
        ArrayList<CookieSpi> result = new ArrayList<CookieSpi>();
        for (String hostKey : this.cookies.keySet()) {
            result.addAll(this.get(hostKey));
        }
        return result;
    }

    @Override
    public boolean remove(URI httpUrl, CookieSpi cookie) {
        return this.remove(httpUrl.getHost(), cookie);
    }

    @Override
    public boolean clear() {
        this.cookies.clear();
        return true;
    }

    private List<CookieSpi> get(String hostKey) {
        ArrayList<CookieSpi> result = new ArrayList<CookieSpi>();
        if (this.cookies.containsKey(hostKey)) {
            Collection<CookieSpi> cookies = this.cookies.get(hostKey).values();
            for (CookieSpi cookie : cookies) {
                if (cookie.isExpired()) {
                    this.remove(hostKey, cookie);
                    continue;
                }
                result.add(cookie);
            }
        }
        return result;
    }

    private boolean remove(String hostKey, CookieSpi cookie) {
        String cookieKey = this.cookieKey(cookie);
        if (this.cookies.containsKey(hostKey) && this.cookies.get(hostKey).containsKey(cookieKey)) {
            this.cookies.get(hostKey).remove(cookieKey);
            return true;
        }
        return false;
    }

    private String cookieKey(CookieSpi cookie) {
        return cookie == null ? null : cookie.getName() + cookie.getDomain();
    }
}

