/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.multi.ListValueMap;
import top.redscorpion.core.net.url.UrlBuilder;
import top.redscorpion.core.net.url.UrlQuery;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.GlobalHeaders;
import top.redscorpion.http.HttpGlobalConfig;
import top.redscorpion.http.RsHttp;
import top.redscorpion.http.client.HeaderOperation;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.AbstractFormBody;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.body.MultipartBody;
import top.redscorpion.http.client.body.StringBody;
import top.redscorpion.http.client.body.UrlEncodedFormBody;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.http.client.engine.ClientEngineFactory;
import top.redscorpion.http.meta.HeaderName;
import top.redscorpion.http.meta.Method;

public class Request
implements HeaderOperation<Request> {
    private static final Charset DEFAULT_CHARSET = RsCharset.UTF_8;
    private Method method;
    private UrlBuilder url;
    private Charset charset = DEFAULT_CHARSET;
    private final ListValueMap<String, String> headers;
    private HttpBody body;
    private int maxRedirects;
    private boolean isRest;

    public static Request ofWithoutEncode(String url) {
        return Request.of(url, null);
    }

    public static Request of(String url) {
        return Request.of(url, DEFAULT_CHARSET);
    }

    public static Request of(String url, Charset decodeAndEncodeCharset) {
        return Request.of(UrlBuilder.ofHttp(url, decodeAndEncodeCharset));
    }

    public static Request of(UrlBuilder url) {
        return new Request().url(url);
    }

    public Request() {
        this.method = Method.GET;
        this.headers = new ListValueMap(new LinkedHashMap());
        this.maxRedirects = HttpGlobalConfig.getMaxRedirects();
        this.header(GlobalHeaders.INSTANCE.headers(), false);
    }

    public Method method() {
        return this.method;
    }

    public Request method(Method method) {
        this.method = method;
        return this;
    }

    public UrlBuilder url() {
        return this.url;
    }

    public UrlBuilder handledUrl() {
        return this.urlWithParamIfGet();
    }

    public Request url(UrlBuilder url) {
        this.url = url;
        return this;
    }

    public Request charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Charset charset() {
        return this.charset;
    }

    public Request setEncodeUrl(boolean isEncodeUrl) {
        Assert.notNull(this.url, "Request URL must be not null!", new Object[0]);
        this.url.setCharset(isEncodeUrl ? this.charset : null);
        return this;
    }

    @Override
    public Map<String, ? extends Collection<String>> headers() {
        return RsMap.view(this.headers);
    }

    @Override
    public Request header(String name, String value, boolean isOverride) {
        if (null == name) {
            return this;
        }
        if (null == value) {
            this.headers.remove(name);
            return this;
        }
        if (isOverride) {
            this.headers.put(name.trim(), (String)((Object)RsList.of(value)));
        } else {
            this.headers.putValue(name.trim(), value);
        }
        return this;
    }

    public Request basicAuth(String username, String password) {
        return (Request)this.basicAuth(username, password, this.charset);
    }

    public HttpBody body() {
        return this.body;
    }

    public String bodyStr() {
        return RsString.str(this.bodyBytes(), this.charset);
    }

    public byte[] bodyBytes() {
        return this.body == null ? null : this.body.getBytes();
    }

    public InputStream bodyStream() {
        return this.body == null ? null : this.body.getStream();
    }

    public HttpBody handledBody() {
        if (Method.GET.equals((Object)this.method) && !this.isRest) {
            return null;
        }
        return this.body();
    }

    public Request form(Map<String, Object> formMap) {
        AtomicBoolean isMultiPart = new AtomicBoolean(false);
        formMap.forEach((key, value) -> {
            if (Request.hasMultipartValue(value)) {
                isMultiPart.set(true);
            }
        });
        if (isMultiPart.get()) {
            return this.body(MultipartBody.of(formMap, this.charset()));
        }
        return this.body(new UrlEncodedFormBody(formMap, this.charset()));
    }

    public Request body(String body) {
        return this.body(new StringBody(body, this.charset()));
    }

    public Request body(HttpBody body) {
        String contentType;
        this.body = body;
        if (RsString.isBlank(this.header(HeaderName.CONTENT_TYPE)) && null != (contentType = body.contentType(this.charset()))) {
            this.header(HeaderName.CONTENT_TYPE, contentType, true);
        }
        return this;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    public Request setMaxRedirects(int maxRedirects) {
        this.maxRedirects = Math.max(maxRedirects, 0);
        return this;
    }

    public Request setRest(boolean isRest) {
        this.isRest = isRest;
        return this;
    }

    public Response send() {
        return this.send(ClientEngineFactory.getEngine());
    }

    public Response send(ClientEngine engine) {
        return engine.send(this);
    }

    private UrlBuilder urlWithParamIfGet() {
        HttpBody body;
        if (Method.GET.equals((Object)this.method) && !this.isRest && (body = this.body) instanceof AbstractFormBody) {
            UrlBuilder urlBuilder = UrlBuilder.of(this.url);
            UrlQuery query = urlBuilder.getQuery();
            if (null == query) {
                query = UrlQuery.of();
                urlBuilder.setQuery(query);
            }
            query.addAll(((AbstractFormBody)body).form());
            return urlBuilder;
        }
        return this.url();
    }

    public String toString() {
        return RsHttp.toString(this);
    }

    private static boolean hasMultipartValue(Object value) {
        if (value instanceof Iterable) {
            for (Object subValue : (Iterable)value) {
                if (!Request.hasMultipartValue(subValue)) continue;
                return true;
            }
        }
        return value instanceof File || value instanceof Path || value instanceof Resource || value instanceof InputStream || value instanceof Reader;
    }
}

