/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.file.FileMagicNumber;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsFileName;
import top.redscorpion.core.util.RsHex;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsString;

public class RsFileType {
    private static final Map<String, String> FILE_TYPE_MAP = new ConcurrentSkipListMap<String, String>();

    public static String putFileType(String fileStreamHexHead, String extName) {
        return FILE_TYPE_MAP.put(fileStreamHexHead, extName);
    }

    public static String removeFileType(String fileStreamHexHead) {
        return FILE_TYPE_MAP.remove(fileStreamHexHead);
    }

    public static String getType(String fileStreamHexHead) {
        if (RsString.isBlank(fileStreamHexHead)) {
            return null;
        }
        for (Map.Entry<String, String> fileTypeEntry : FILE_TYPE_MAP.entrySet()) {
            if (!RsString.startWith(fileStreamHexHead, fileTypeEntry.getKey(), true)) continue;
            return fileTypeEntry.getValue();
        }
        byte[] bytes = RsHex.decode(fileStreamHexHead);
        return FileMagicNumber.getMagicNumber(bytes).getExtension();
    }

    public static String getType(InputStream in, boolean isExact) throws IORuntimeException {
        if (null == in) {
            return null;
        }
        return isExact ? RsFileType.getType(RsFileType.readHex8192Upper(in)) : RsFileType.getType(RsFileType.readHex64Upper(in));
    }

    public static String getType(InputStream in, String filename, boolean isExact) throws IORuntimeException {
        String typeName = RsFileType.getType(in, isExact);
        if (null == typeName) {
            typeName = RsFileName.extName(filename);
        } else if ("zip".equals(typeName)) {
            String extName = RsFileName.extName(filename);
            if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("jar".equalsIgnoreCase(extName)) {
                typeName = "jar";
            } else if ("war".equalsIgnoreCase(extName)) {
                typeName = "war";
            } else if ("ofd".equalsIgnoreCase(extName)) {
                typeName = "ofd";
            } else if ("apk".equalsIgnoreCase(extName)) {
                typeName = "apk";
            }
        } else if ("jar".equals(typeName)) {
            String extName = RsFileName.extName(filename);
            if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("zip".equalsIgnoreCase(extName)) {
                typeName = "zip";
            } else if ("apk".equalsIgnoreCase(extName)) {
                typeName = "apk";
            }
        }
        return typeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getType(File file, boolean isExact) throws IORuntimeException {
        String string;
        if (!RsFile.isFile(file)) {
            throw new IllegalArgumentException("Not a regular file!");
        }
        InputStream in = null;
        try {
            in = RsIo.toStream(file);
            string = RsFileType.getType(in, file.getName(), isExact);
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly(in);
            throw throwable;
        }
        RsIo.closeQuietly(in);
        return string;
    }

    public static String getType(File file) throws IORuntimeException {
        return RsFileType.getType(file, false);
    }

    public static String getTypeByPath(String path, boolean isExact) throws IORuntimeException {
        return RsFileType.getType(RsFile.file(path), isExact);
    }

    public static String getTypeByPath(String path) throws IORuntimeException {
        return RsFileType.getTypeByPath(path, false);
    }

    private static String readHex8192Upper(InputStream in) throws IORuntimeException {
        try {
            return RsIo.readHex(in, Math.min(8192, in.available()), false);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static String readHex64Upper(InputStream in) throws IORuntimeException {
        return RsIo.readHex(in, 64, false);
    }
}

