/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import top.redscorpion.core.io.buffer.FastByteBuffer;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsNumber;

public class RsByte {
    public static final ByteOrder DEFAULT_ORDER = ByteOrder.LITTLE_ENDIAN;

    public static byte[] toUtf8Bytes(CharSequence str) {
        return RsByte.toBytes(str, RsCharset.UTF_8);
    }

    public static byte[] toBytes(CharSequence str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.toString().getBytes();
        }
        return str.toString().getBytes(charset);
    }

    public static byte[] toBytes(short shortValue, ByteOrder byteOrder) {
        byte[] b = new byte[2];
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            b[0] = (byte)(shortValue & 0xFF);
            b[1] = (byte)(shortValue >> 8 & 0xFF);
        } else {
            b[1] = (byte)(shortValue & 0xFF);
            b[0] = (byte)(shortValue >> 8 & 0xFF);
        }
        return b;
    }

    public static byte[] toBytes(int intValue, ByteOrder byteOrder) {
        return RsByte.fill(intValue, 0, byteOrder, new byte[4]);
    }

    public static byte[] fill(int intValue, int start, ByteOrder byteOrder, byte[] bytes) {
        int offset = ByteOrder.LITTLE_ENDIAN == byteOrder ? 0 : bytes.length - 1;
        for (int i = start; i < bytes.length; ++i) {
            bytes[Math.abs((int)(i - offset))] = (byte)(intValue & 0xFF);
            intValue >>= 8;
        }
        return bytes;
    }

    public static byte[] toBytes(float floatValue, ByteOrder byteOrder) {
        return RsByte.toBytes(Float.floatToIntBits(floatValue), byteOrder);
    }

    public static byte[] toBytes(double doubleValue, ByteOrder byteOrder) {
        return RsByte.toBytes(Double.doubleToLongBits(doubleValue), byteOrder);
    }

    public static byte[] toBytes(Number number) {
        return RsByte.toBytes(number, DEFAULT_ORDER);
    }

    public static byte[] toBytes(Number number, ByteOrder byteOrder) {
        if (number instanceof Byte) {
            return new byte[]{number.byteValue()};
        }
        if (number instanceof Double) {
            return RsByte.toBytes(number.doubleValue(), byteOrder);
        }
        if (number instanceof Long) {
            return RsByte.toBytes(number.longValue(), byteOrder);
        }
        if (number instanceof Integer) {
            return RsByte.toBytes(number.intValue(), byteOrder);
        }
        if (number instanceof Short) {
            return RsByte.toBytes(number.shortValue(), byteOrder);
        }
        if (number instanceof Float) {
            return RsByte.toBytes(number.floatValue(), byteOrder);
        }
        if (number instanceof BigInteger) {
            return ((BigInteger)number).toByteArray();
        }
        return RsByte.toBytes(number.doubleValue(), byteOrder);
    }

    public static short toShort(byte[] bytes, ByteOrder byteOrder) {
        return RsByte.toShort(bytes, 0, byteOrder);
    }

    public static short toShort(byte[] bytes, int start, ByteOrder byteOrder) {
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            return (short)(bytes[start] & 0xFF | (bytes[start + 1] & 0xFF) << 8);
        }
        return (short)(bytes[start + 1] & 0xFF | (bytes[start] & 0xFF) << 8);
    }

    public static int toInt(byte[] bytes, ByteOrder byteOrder) {
        return RsByte.toInt(bytes, 0, byteOrder);
    }

    public static int toInt(byte[] bytes, int start, ByteOrder byteOrder) {
        if (bytes.length - start < 4) {
            throw new IllegalArgumentException("bytes length must be greater than or equal to 8");
        }
        int values = 0;
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 3; i >= 0; --i) {
                values <<= 8;
                values |= bytes[i + start] & 0xFF;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                values <<= 8;
                values |= bytes[i + start] & 0xFF;
            }
        }
        return values;
    }

    public static long toLong(byte[] bytes, ByteOrder byteOrder) {
        return RsByte.toLong(bytes, 0, byteOrder);
    }

    public static long toLong(byte[] bytes, int start, ByteOrder byteOrder) {
        if (bytes.length - start < 8) {
            throw new IllegalArgumentException("bytes length must be greater than or equal to 8");
        }
        long values = 0L;
        if (ByteOrder.LITTLE_ENDIAN == byteOrder) {
            for (int i = 7; i >= 0; --i) {
                values <<= 8;
                values |= (long)bytes[i + start] & 0xFFL;
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                values <<= 8;
                values |= (long)bytes[i + start] & 0xFFL;
            }
        }
        return values;
    }

    public static float toFloat(byte[] bytes, ByteOrder byteOrder) {
        return Float.intBitsToFloat(RsByte.toInt(bytes, byteOrder));
    }

    public static double toDouble(byte[] bytes, ByteOrder byteOrder) {
        return Double.longBitsToDouble(RsByte.toLong(bytes, byteOrder));
    }

    public static <T extends Number> T toNumber(byte[] bytes, Class<T> targetClass, ByteOrder byteOrder) throws IllegalArgumentException {
        Number number;
        if (Byte.class == targetClass) {
            number = bytes[0];
        } else if (Short.class == targetClass) {
            number = RsByte.toShort(bytes, byteOrder);
        } else if (Integer.class == targetClass) {
            number = RsByte.toInt(bytes, byteOrder);
        } else if (AtomicInteger.class == targetClass) {
            number = new AtomicInteger(RsByte.toInt(bytes, byteOrder));
        } else if (Long.class == targetClass) {
            number = RsByte.toLong(bytes, byteOrder);
        } else if (AtomicLong.class == targetClass) {
            number = new AtomicLong(RsByte.toLong(bytes, byteOrder));
        } else if (LongAdder.class == targetClass) {
            LongAdder longValue = new LongAdder();
            longValue.add(RsByte.toLong(bytes, byteOrder));
            number = longValue;
        } else if (Float.class == targetClass) {
            number = Float.valueOf(RsByte.toFloat(bytes, byteOrder));
        } else if (Double.class == targetClass) {
            number = RsByte.toDouble(bytes, byteOrder);
        } else if (DoubleAdder.class == targetClass) {
            DoubleAdder doubleAdder = new DoubleAdder();
            doubleAdder.add(RsByte.toDouble(bytes, byteOrder));
            number = doubleAdder;
        } else if (BigDecimal.class == targetClass) {
            number = RsNumber.toBigDecimal(RsByte.toDouble(bytes, byteOrder));
        } else if (BigInteger.class == targetClass) {
            number = BigInteger.valueOf(RsByte.toLong(bytes, byteOrder));
        } else if (Number.class == targetClass) {
            number = RsByte.toDouble(bytes, byteOrder);
        } else {
            throw new IllegalArgumentException("Unsupported Number type: " + targetClass.getName());
        }
        return (T)number;
    }

    public static byte[] concat(byte[] ... byteArrays) {
        int totalLength = 0;
        for (byte[] byteArray : byteArrays) {
            totalLength += byteArray.length;
        }
        FastByteBuffer buffer = new FastByteBuffer(totalLength);
        for (byte[] byteArray : byteArrays) {
            buffer.append(byteArray);
        }
        return buffer.toArrayZeroCopyIfPossible();
    }
}

