/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text;

import java.io.Serializable;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsString;

public class StringTrimer
implements UnaryOperator<CharSequence>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final StringTrimer TRIM_BLANK = new StringTrimer(TrimMode.BOTH, RsChar::isBlankChar);
    public static final StringTrimer TRIM_PREFIX_BLANK = new StringTrimer(TrimMode.PREFIX, RsChar::isBlankChar);
    public static final StringTrimer TRIM_SUFFIX_BLANK = new StringTrimer(TrimMode.SUFFIX, RsChar::isBlankChar);
    private final TrimMode mode;
    private final Predicate<Character> predicate;

    public StringTrimer(TrimMode mode, Predicate<Character> predicate) {
        this.mode = mode;
        this.predicate = predicate;
    }

    @Override
    public String apply(CharSequence str) {
        int begin;
        if (RsString.isEmpty(str)) {
            return RsString.toStringOrNull(str);
        }
        int length = str.length();
        int end = length;
        if (this.mode == TrimMode.PREFIX || this.mode == TrimMode.BOTH) {
            for (begin = 0; begin < end && this.predicate.test(Character.valueOf(str.charAt(begin))); ++begin) {
            }
        }
        if (this.mode == TrimMode.SUFFIX || this.mode == TrimMode.BOTH) {
            while (begin < end && this.predicate.test(Character.valueOf(str.charAt(end - 1)))) {
                --end;
            }
        }
        String result = begin > 0 || end < length ? str.toString().substring(begin, end) : str.toString();
        return result;
    }

    public static enum TrimMode {
        PREFIX,
        SUFFIX,
        BOTH;

    }
}

