/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect.creator;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.reflect.creator.DefaultObjectCreator;
import top.redscorpion.core.reflect.creator.ObjectCreator;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsReflect;

public class PossibleObjectCreator<T>
implements ObjectCreator<T> {
    final Class<T> clazz;

    public static <T> PossibleObjectCreator<T> of(Class<T> clazz) {
        return new PossibleObjectCreator<T>(clazz);
    }

    public PossibleObjectCreator(Class<T> clazz) {
        this.clazz = Assert.notNull(clazz);
    }

    @Override
    public T create() {
        Class<T> type = this.clazz;
        if (type.isPrimitive()) {
            return (T)RsClass.getPrimitiveDefaultValue(type);
        }
        type = PossibleObjectCreator.resolveType(type);
        try {
            return DefaultObjectCreator.of(type, new Object[0]).create();
        }
        catch (Exception exception) {
            Constructor<T>[] constructors;
            if (type.isEnum()) {
                return type.getEnumConstants()[0];
            }
            if (type.isArray()) {
                return (T)Array.newInstance(type.getComponentType(), 0);
            }
            for (Constructor<T> constructor : constructors = RsConstructor.getConstructors(type)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                RsReflect.setAccessible(constructor);
                try {
                    return constructor.newInstance(RsClass.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private static Class<?> resolveType(Class<?> type) {
        if (type.isAssignableFrom(AbstractMap.class)) {
            return HashMap.class;
        }
        if (type.isAssignableFrom(List.class)) {
            return ArrayList.class;
        }
        if (type == SortedSet.class) {
            return TreeSet.class;
        }
        if (type.isAssignableFrom(Set.class)) {
            return HashSet.class;
        }
        return type;
    }
}

