/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net.url;

import java.nio.charset.Charset;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.net.url.RFC3986;
import top.redscorpion.core.util.RsChar;

public class UrlEncoder {
    public static String encodeAll(String url, Charset charset) throws RsException {
        return RFC3986.UNRESERVED.encode(url, charset, new char[0]);
    }

    public static String encodeQuery(String url, Charset charset) {
        return RFC3986.QUERY.encode(url, charset, new char[0]);
    }

    public static String encodeBlank(CharSequence urlStr) {
        if (urlStr == null) {
            return null;
        }
        int len = urlStr.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = urlStr.charAt(i);
            if (RsChar.isBlankChar(c)) {
                sb.append("%20");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

