/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.lang.tuple;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import top.redscorpion.core.collection.iter.ArrayIter;
import top.redscorpion.core.exception.CloneException;

public class Tuple
implements Iterable<Object>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7689304393482182157L;
    private final Object[] members;
    private int hashCode;
    private boolean cacheHash;

    public static Tuple of(Object ... members) {
        return new Tuple(members);
    }

    public Tuple(Object ... members) {
        this.members = members;
    }

    public int hashCode() {
        if (this.cacheHash && 0 != this.hashCode) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.members);
        if (this.cacheHash) {
            this.hashCode = result;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return false != Arrays.deepEquals(this.members, other.members);
    }

    public String toString() {
        return Arrays.toString(this.members);
    }

    @Override
    public Iterator<Object> iterator() {
        return new ArrayIter<Object>(this.members);
    }

    @Override
    public final Spliterator<Object> spliterator() {
        return Spliterators.spliterator(this.members, 16);
    }

    public Tuple clone() {
        try {
            return (Tuple)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }
}

