/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.stream;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsIo;

public class StreamWriter {
    private final OutputStream out;
    private final boolean closeAfterWrite;

    public static StreamWriter of(OutputStream out, boolean closeAfterWrite) {
        return new StreamWriter(out, closeAfterWrite);
    }

    public StreamWriter(OutputStream out, boolean closeAfterWrite) {
        this.out = out;
        this.closeAfterWrite = closeAfterWrite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(byte[] content) throws IORuntimeException {
        OutputStream out = this.out;
        try {
            out.write(content);
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                RsIo.closeQuietly(out);
                throw throwable;
            }
        }
        RsIo.closeQuietly(out);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeObjs(Object ... contents) throws IORuntimeException {
        ObjectOutputStream osw = null;
        try {
            osw = this.out instanceof ObjectOutputStream ? (ObjectOutputStream)this.out : new ObjectOutputStream(this.out);
            for (Object content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
            }
            osw.flush();
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                RsIo.closeQuietly(osw);
                throw throwable;
            }
        }
        RsIo.closeQuietly(osw);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeStrs(Charset charset, CharSequence ... contents) throws IORuntimeException {
        OutputStreamWriter osw = null;
        try {
            osw = RsIo.toWriter(this.out, charset);
            for (CharSequence content : contents) {
                if (content == null) continue;
                osw.write(content.toString());
            }
            osw.flush();
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                RsIo.closeQuietly(osw);
                throw throwable;
            }
        }
        RsIo.closeQuietly(osw);
        return;
    }
}

