/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.io.buffer;

public abstract class FastBuffer {
    protected final int minChunkLen;
    protected int buffersCount;
    protected int currentBufferIndex = -1;
    protected int offset;
    protected int size;

    public FastBuffer(int size) {
        if (size <= 0) {
            size = 8192;
        }
        this.minChunkLen = Math.abs(size);
    }

    public int index() {
        return this.currentBufferIndex;
    }

    public int offset() {
        return this.offset;
    }

    public void reset() {
        this.size = 0;
        this.offset = 0;
        this.currentBufferIndex = -1;
        this.buffersCount = 0;
    }

    public int length() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected abstract void ensureCapacity(int var1);
}

