/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.func;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import top.redscorpion.core.exception.RsExceptionHandle;

@FunctionalInterface
public interface SerConsumer<T>
extends Consumer<T>,
Serializable {
    public void accepting(T var1) throws Throwable;

    @Override
    default public void accept(T t) {
        try {
            this.accepting(t);
        }
        catch (Throwable e) {
            throw RsExceptionHandle.wrapRuntime(e);
        }
    }

    @SafeVarargs
    public static <T> SerConsumer<T> multi(SerConsumer<T> ... consumers) {
        return Stream.of(consumers).reduce(SerConsumer::andThen).orElseGet(() -> o -> {});
    }

    @Override
    default public SerConsumer<T> andThen(SerConsumer<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    public static <T> SerConsumer<T> nothing() {
        return t -> {};
    }
}

