/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.convert.AbstractConverterWithRoot;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.lang.tuple.Pair;
import top.redscorpion.core.reflect.AbstractTypeReference;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class PairConverter
extends AbstractConverterWithRoot
implements Serializable {
    private static final long serialVersionUID = 1L;

    public PairConverter(Converter rootConverter) {
        super(rootConverter);
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof AbstractTypeReference) {
            targetType = ((AbstractTypeReference)targetType).getType();
        }
        Type leftType = RsType.getTypeArgument(targetType, 0);
        Type rightType = RsType.getTypeArgument(targetType, 1);
        return this.convert(leftType, rightType, value);
    }

    public Pair<?, ?> convert(Type leftType, Type rightType, Object value) throws ConvertException {
        Map<Object, Object> map = null;
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            map = RsMap.of(entry.getKey(), entry.getValue());
        } else if (value instanceof Pair) {
            Pair entry = (Pair)value;
            map = RsMap.of(entry.getLeft(), entry.getRight());
        } else if (value instanceof Map) {
            map = (Map)value;
        } else if (value instanceof CharSequence) {
            CharSequence str = (CharSequence)value;
            map = PairConverter.strToMap(str);
        } else if (RsBean.isReadableBean(value.getClass())) {
            map = RsBean.toBeanMap(value);
        }
        if (null != map) {
            return this.mapToPair(leftType, rightType, map);
        }
        throw new ConvertException("Unsupported to map from [{}] of type: {}", value, value.getClass().getName());
    }

    private static Map<CharSequence, CharSequence> strToMap(CharSequence str) {
        int index = RsString.indexOf(str, c -> c.charValue() == ':' || c.charValue() == '=' || c.charValue() == ',', 0, str.length());
        if (index > -1) {
            return RsMap.of(str.subSequence(0, index), str.subSequence(index + 1, str.length()));
        }
        return null;
    }

    private Pair<?, ?> mapToPair(Type keyType, Type valueType, Map map) {
        Object right;
        Object left;
        if (1 == map.size()) {
            Map.Entry entry = map.entrySet().iterator().next();
            left = entry.getKey();
            right = entry.getValue();
        } else {
            left = map.get("left");
            right = map.get("right");
        }
        return Pair.of(RsType.isUnknown(keyType) ? left : this.rootConverter.convert(keyType, left), RsType.isUnknown(valueType) ? right : this.rootConverter.convert(valueType, right));
    }
}

