/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.bean.copier.BeanCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.bean.copier.ValueProvider;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.Converter;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.MapProxy;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsSerialize;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsType;

public class BeanConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static BeanConverter INSTANCE = new BeanConverter();
    private final CopyOptions copyOptions;

    public BeanConverter() {
        this(CopyOptions.of().setIgnoreError(true));
    }

    public BeanConverter(CopyOptions copyOptions) {
        this.copyOptions = copyOptions;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Assert.notNull(targetType);
        if (null == value) {
            return null;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(targetType, value);
        }
        Class<?> targetClass = RsType.getClass(targetType);
        Assert.notNull(targetClass, "Target type is not a class!", new Object[0]);
        return this.convertInternal(targetType, targetClass, value);
    }

    private Object convertInternal(Type targetType, Class<?> targetClass, Object value) {
        if (value instanceof Map || value instanceof ValueProvider || RsBean.isReadableBean(value.getClass())) {
            if (value instanceof Map && targetClass.isInterface()) {
                return MapProxy.of((Map)value).toProxyBean(targetClass);
            }
            return BeanCopier.of(value, RsConstructor.newInstanceIfPossible(targetClass), targetType, this.copyOptions).copy();
        }
        if (value instanceof byte[]) {
            return RsSerialize.deserialize((byte[])value, new Class[0]);
        }
        if (RsString.isEmptyIfStr(value)) {
            return null;
        }
        throw new ConvertException("Unsupported source type: [{}] to [{}]", value.getClass(), targetType);
    }
}

