/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.path;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.bean.DynaBean;
import top.redscorpion.core.bean.path.BeanPath;
import top.redscorpion.core.bean.path.NodeBeanFactory;
import top.redscorpion.core.bean.path.node.EmptyNode;
import top.redscorpion.core.bean.path.node.ListNode;
import top.redscorpion.core.bean.path.node.NameNode;
import top.redscorpion.core.bean.path.node.Node;
import top.redscorpion.core.bean.path.node.RangeNode;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.reflect.RsField;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;

public class DefaultNodeBeanFactory
implements NodeBeanFactory<Object> {
    public static final DefaultNodeBeanFactory INSTANCE = new DefaultNodeBeanFactory();

    @Override
    public Object create(Object parent, BeanPath<Object> beanPath) {
        if (parent instanceof Map || parent instanceof List || RsArray.isArray(parent)) {
            Node node = ((BeanPath)beanPath.next()).getNode();
            if (node instanceof NameNode) {
                return ((NameNode)node).isNumber() ? new ArrayList() : new HashMap();
            }
            return new HashMap();
        }
        Node node = beanPath.getNode();
        if (node instanceof NameNode) {
            String name = ((NameNode)node).getName();
            Field field = RsField.getField(parent.getClass(), name);
            if (null == field) {
                throw new IllegalArgumentException("No field found for name: " + name);
            }
            return RsConstructor.newInstanceIfPossible(field.getType());
        }
        throw new UnsupportedOperationException("Unsupported node type: " + node.getClass());
    }

    @Override
    public Object getValue(Object bean, BeanPath<Object> beanPath) {
        Node node = beanPath.getNode();
        if (null == node || node instanceof EmptyNode) {
            return null;
        }
        if (node instanceof ListNode) {
            return DefaultNodeBeanFactory.getValueByListNode(bean, (ListNode)node);
        }
        if (node instanceof NameNode) {
            return DefaultNodeBeanFactory.getValueByNameNode(bean, (NameNode)node);
        }
        if (node instanceof RangeNode) {
            return DefaultNodeBeanFactory.getValueByRangeNode(bean, (RangeNode)node);
        }
        throw new UnsupportedOperationException("Unsupported node type: " + node.getClass());
    }

    @Override
    public Object setValue(Object bean, Object value, BeanPath<Object> beanPath) {
        Node node = beanPath.getNode();
        if (null == node || node instanceof EmptyNode) {
            return bean;
        }
        if (node instanceof NameNode) {
            return DynaBean.of(bean).set(((NameNode)node).getName(), value).getBean();
        }
        throw new UnsupportedOperationException("Unsupported node type: " + node.getClass());
    }

    private static Object getValueByListNode(Object bean, ListNode node) {
        String[] names = node.getUnWrappedNames();
        if (bean instanceof Collection) {
            return RsColl.getAny((Collection)bean, RsConvert.convert(int[].class, (Object)names));
        }
        if (RsArray.isArray(bean)) {
            return RsArray.getAny(bean, RsConvert.convert(int[].class, (Object)names));
        }
        Map<String, Object> map = bean instanceof Map ? (Map<String, Object>)bean : RsBean.toBeanMap(bean);
        return RsMap.getAny(map, names);
    }

    private static Object getValueByNameNode(Object bean, NameNode node) {
        String name = node.getName();
        if ("$".equals(name)) {
            return bean;
        }
        Object value = DynaBean.of(bean).get(name);
        if (null == value && RsString.lowerFirst(RsClass.getClassName(bean, true)).equals(name)) {
            value = bean;
        }
        return value;
    }

    private static Object getValueByRangeNode(Object bean, RangeNode node) {
        if (bean instanceof Collection) {
            return RsColl.sub((Collection)bean, node.getStart(), node.getEnd(), node.getStep());
        }
        if (RsArray.isArray(bean)) {
            return RsArray.sub(bean, node.getStart(), node.getEnd(), node.getStep());
        }
        throw new UnsupportedOperationException("Can not get range value for: " + bean.getClass());
    }
}

