/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.bean.copier.AbstractCopier;
import top.redscorpion.core.bean.copier.CopyOptions;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.mutable.MutableEntry;
import top.redscorpion.core.map.CaseInsensitiveMap;
import top.redscorpion.core.map.MapWrapper;
import top.redscorpion.core.util.RsType;

public class MapToBeanCopier<T>
extends AbstractCopier<Map<?, ?>, T> {
    private final Type targetType;

    public MapToBeanCopier(Map<?, ?> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        Object raw;
        if (source instanceof MapWrapper && (raw = ((MapWrapper)source).getRaw()) instanceof CaseInsensitiveMap) {
            copyOptions.setIgnoreCase(true);
        }
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = this.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        ((Map)this.source).forEach((sKey, sValue) -> {
            if (null == sKey) {
                return;
            }
            MutableEntry<Object, Object> entry = this.copyOptions.editField(sKey.toString(), sValue);
            if (null == entry) {
                return;
            }
            Object sFieldName = entry.getKey();
            if (null == sFieldName) {
                return;
            }
            PropDesc tDesc = this.copyOptions.findPropDesc(targetPropDescMap, sFieldName.toString());
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Object newValue = entry.getValue();
            if (!this.copyOptions.testPropertyFilter(tDesc.getField(), newValue)) {
                return;
            }
            Type fieldType = RsType.getActualType(this.targetType, tDesc.getFieldType());
            newValue = this.copyOptions.convertField(fieldType, newValue);
            tDesc.setValue(this.target, newValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

