/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import top.redscorpion.core.bean.PropDesc;
import top.redscorpion.core.bean.path.AbstractBeanDesc;
import top.redscorpion.core.reflect.RsField;
import top.redscorpion.core.reflect.method.RsMethod;
import top.redscorpion.core.reflect.method.RsMethodName;
import top.redscorpion.core.util.RsBoolean;
import top.redscorpion.core.util.RsModifier;
import top.redscorpion.core.util.RsString;

public class StrictBeanDesc
extends AbstractBeanDesc {
    private static final long serialVersionUID = 1L;

    public StrictBeanDesc(Class<?> beanClass) {
        super(beanClass);
        this.init();
    }

    private void init() {
        Field[] fields;
        Class beanClass = this.beanClass;
        Map propMap = this.propMap;
        Method[] gettersAndSetters = RsMethod.getPublicMethods(beanClass, RsMethod::isGetterOrSetterIgnoreCase);
        for (Field field2 : fields = RsField.getFields(beanClass, field -> !RsModifier.isStatic(field) && !RsField.isOuterClassField(field))) {
            PropDesc prop = this.createProp(field2, gettersAndSetters);
            propMap.putIfAbsent(prop.getFieldName(), prop);
        }
    }

    private PropDesc createProp(Field field, Method[] methods) {
        PropDesc prop = this.findProp(field, methods, false);
        if (null == prop.getter || null == prop.setter) {
            PropDesc propIgnoreCase = this.findProp(field, methods, true);
            if (null == prop.getter) {
                prop.getter = propIgnoreCase.getter;
            }
            if (null == prop.setter) {
                prop.setter = propIgnoreCase.setter;
            }
        }
        return prop;
    }

    private PropDesc findProp(Field field, Method[] gettersOrSetters, boolean ignoreCase) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooleanField = RsBoolean.isBoolean(fieldType);
        Method[] getterAndSetter = this.findGetterAndSetter(fieldName, fieldType, gettersOrSetters, ignoreCase);
        if (isBooleanField) {
            if (null == getterAndSetter[0]) {
                getterAndSetter[0] = StrictBeanDesc.getGetterForBoolean(gettersOrSetters, fieldName, ignoreCase);
            }
            if (null == getterAndSetter[1]) {
                getterAndSetter[1] = StrictBeanDesc.getSetterForBoolean(gettersOrSetters, fieldName, ignoreCase);
            }
        }
        return new PropDesc(field, getterAndSetter[0], getterAndSetter[1]);
    }

    private Method[] findGetterAndSetter(String fieldName, Class<?> fieldType, Method[] gettersOrSetters, boolean ignoreCase) {
        Method getter = null;
        Method setter = null;
        for (Method method : gettersOrSetters) {
            String methodName = method.getName();
            if (0 == method.getParameterCount()) {
                if (RsString.equals(methodName, RsMethodName.genGetter(fieldName), ignoreCase) && method.getReturnType().isAssignableFrom(fieldType)) {
                    getter = method;
                }
            } else if (RsString.equals(methodName, RsMethodName.genSetter(fieldName), ignoreCase) && fieldType.isAssignableFrom(method.getParameterTypes()[0])) {
                setter = method;
            }
            if (null != getter && null != setter) break;
        }
        return new Method[]{getter, setter};
    }

    private static Method getGetterForBoolean(Method[] gettersOrSetters, String fieldName, boolean ignoreCase) {
        return RsMethod.getMethod(gettersOrSetters, m -> {
            if (0 != m.getParameterCount() || !RsBoolean.isBoolean(m.getReturnType())) {
                return false;
            }
            if (RsString.startWith(fieldName, "is", ignoreCase) && RsString.equals(fieldName, m.getName(), ignoreCase)) {
                return true;
            }
            return RsString.equals(RsString.upperFirstAndAddPre(fieldName, "is"), m.getName(), ignoreCase);
        });
    }

    private static Method getSetterForBoolean(Method[] gettersOrSetters, String fieldName, boolean ignoreCase) {
        return RsMethod.getMethod(gettersOrSetters, m -> {
            if (1 != m.getParameterCount() || !RsBoolean.isBoolean(m.getParameterTypes()[0])) {
                return false;
            }
            if (RsString.startWith(fieldName, "is", ignoreCase)) {
                return RsString.equals("set" + RsString.removePrefix(fieldName, "is", ignoreCase), m.getName(), ignoreCase);
            }
            return false;
        });
    }
}

