/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.poi.excel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.common.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.IgnoredErrorType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import top.redscorpion.core.comparator.IndexedComparator;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.TableMap;
import top.redscorpion.core.map.concurrent.SafeConcurrentHashMap;
import top.redscorpion.core.map.multi.RowKeyTable;
import top.redscorpion.core.map.multi.Table;
import top.redscorpion.core.reflect.RsField;
import top.redscorpion.core.util.RsBean;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.poi.excel.ExcelBase;
import top.redscorpion.poi.excel.RsRow;
import top.redscorpion.poi.excel.RsWorkbook;
import top.redscorpion.poi.excel.cell.CellEditor;
import top.redscorpion.poi.excel.cell.RsCell;
import top.redscorpion.poi.excel.cell.RsCellRange;
import top.redscorpion.poi.excel.style.Align;
import top.redscorpion.poi.excel.style.DefaultStyleSet;
import top.redscorpion.poi.excel.style.StyleSet;

public class ExcelWriter
extends ExcelBase<ExcelWriter> {
    private boolean onlyAlias;
    private Comparator<String> aliasComparator;
    private StyleSet styleSet;
    private Map<String, Integer> headLocationCache;
    private CellEditor cellEditor;
    private final AtomicInteger currentRow;

    public ExcelWriter() {
        this(true);
    }

    public ExcelWriter(boolean isXlsx) {
        this(RsWorkbook.createBook(isXlsx), null);
    }

    public ExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public ExcelWriter(boolean isXlsx, String sheetName) {
        this(RsWorkbook.createBook(isXlsx), sheetName);
    }

    public ExcelWriter(String destFilePath, String sheetName) {
        this(RsFile.file(destFilePath), sheetName);
    }

    public ExcelWriter(File destFile) {
        this(destFile, null);
    }

    public ExcelWriter(File destFile, String sheetName) {
        this(RsWorkbook.createBookForWriter(destFile), sheetName);
        this.destFile = destFile;
    }

    public ExcelWriter(Workbook workbook, String sheetName) {
        this(RsWorkbook.getOrCreateSheet(workbook, sheetName));
    }

    public ExcelWriter(Sheet sheet) {
        super(sheet);
        this.styleSet = new DefaultStyleSet(this.workbook);
        this.currentRow = new AtomicInteger(0);
    }

    public ExcelWriter setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        return this;
    }

    @Override
    public ExcelWriter setSheet(int sheetIndex) {
        this.reset();
        return (ExcelWriter)super.setSheet(sheetIndex);
    }

    @Override
    public ExcelWriter setSheet(String sheetName) {
        this.reset();
        return (ExcelWriter)super.setSheet(sheetName);
    }

    public ExcelWriter reset() {
        this.resetRow();
        return this;
    }

    @Override
    public ExcelWriter renameSheet(String sheetName) {
        return this.renameSheet(this.workbook.getSheetIndex(this.sheet), sheetName);
    }

    public ExcelWriter renameSheet(int sheet, String sheetName) {
        this.workbook.setSheetName(sheet, sheetName);
        return this;
    }

    public ExcelWriter autoSizeColumnAll() {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.autoSizeColumn(i);
        }
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex) {
        this.sheet.autoSizeColumn(columnIndex);
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells) {
        this.sheet.autoSizeColumn(columnIndex, useMergedCells);
        return this;
    }

    public ExcelWriter disableDefaultStyle() {
        return this.setStyleSet(null);
    }

    public ExcelWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        return this;
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public ExcelWriter setCurrentRowToEnd() {
        return this.setCurrentRow(this.getRowCount());
    }

    public ExcelWriter passCurrentRow() {
        this.currentRow.incrementAndGet();
        return this;
    }

    public ExcelWriter passRows(int rows) {
        this.currentRow.addAndGet(rows);
        return this;
    }

    public ExcelWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    public ExcelWriter setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    @Override
    public ExcelWriter setHeaderAlias(Map<String, String> headerAlias) {
        this.aliasComparator = null;
        return (ExcelWriter)super.setHeaderAlias(headerAlias);
    }

    @Override
    public ExcelWriter clearHeaderAlias() {
        this.aliasComparator = null;
        return (ExcelWriter)super.clearHeaderAlias();
    }

    @Override
    public ExcelWriter addHeaderAlias(String name, String alias) {
        this.aliasComparator = null;
        return (ExcelWriter)super.addHeaderAlias(name, alias);
    }

    public ExcelWriter setOnlyAlias(boolean isOnlyAlias) {
        this.onlyAlias = isOnlyAlias;
        return this;
    }

    public ExcelWriter setFreezePane(int rowSplit) {
        return this.setFreezePane(0, rowSplit);
    }

    public ExcelWriter setFreezePane(int colSplit, int rowSplit) {
        this.getSheet().createFreezePane(colSplit, rowSplit);
        return this;
    }

    public ExcelWriter setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0) {
            this.sheet.setDefaultColumnWidth(width);
        } else {
            this.sheet.setColumnWidth(columnIndex, width * 256);
        }
        return this;
    }

    public ExcelWriter setDefaultRowHeight(int height) {
        return this.setRowHeight(-1, height);
    }

    public ExcelWriter setRowHeight(int rownum, int height) {
        if (rownum < 0) {
            this.sheet.setDefaultRowHeightInPoints((float)height);
        } else {
            Row row = this.sheet.getRow(rownum);
            if (null != row) {
                row.setHeightInPoints((float)height);
            }
        }
        return this;
    }

    public ExcelWriter setHeaderOrFooter(String text, Align align, boolean isFooter) {
        Footer headerFooter = isFooter ? this.sheet.getFooter() : this.sheet.getHeader();
        switch (align) {
            case LEFT: {
                headerFooter.setLeft(text);
                break;
            }
            case RIGHT: {
                headerFooter.setRight(text);
                break;
            }
            case CENTER: {
                headerFooter.setCenter(text);
                break;
            }
        }
        return this;
    }

    public ExcelWriter addIgnoredErrors(CellRangeAddress cellRangeAddress, IgnoredErrorType ... ignoredErrorTypes) throws UnsupportedOperationException {
        XSSFSheet xssfSheet;
        Sheet sheet = this.sheet;
        if (sheet instanceof XSSFSheet) {
            ((XSSFSheet)sheet).addIgnoredErrors(cellRangeAddress, ignoredErrorTypes);
            return this;
        }
        if (sheet instanceof SXSSFSheet && null != (xssfSheet = (XSSFSheet)RsField.getFieldValue((Object)sheet, "_sh"))) {
            xssfSheet.addIgnoredErrors(cellRangeAddress, ignoredErrorTypes);
        }
        throw new UnsupportedOperationException("Only XSSFSheet supports addIgnoredErrors");
    }

    public ExcelWriter addSelect(int x, int y, String ... selectList) {
        return this.addSelect(new CellRangeAddressList(y, y, x, x), selectList);
    }

    public ExcelWriter addSelect(CellRangeAddressList regions, String ... selectList) {
        DataValidationConstraint constraint;
        DataValidationHelper validationHelper = this.sheet.getDataValidationHelper();
        DataValidation dataValidation = validationHelper.createValidation(constraint = validationHelper.createExplicitListConstraint(selectList), regions);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        return this.addValidationData(dataValidation);
    }

    public ExcelWriter addValidationData(DataValidation dataValidation) {
        this.sheet.addValidationData(dataValidation);
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        return this.merge(lastColumn, content, true);
    }

    public ExcelWriter merge(int lastColumn, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int rowIndex = this.currentRow.get();
        this.merge(RsCellRange.ofSingleRow(rowIndex, lastColumn), content, isSetHeaderStyle);
        if (null != content) {
            this.currentRow.incrementAndGet();
        }
        return this;
    }

    public ExcelWriter merge(CellRangeAddress cellRangeAddress, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        CellStyle style = null;
        if (null != this.styleSet) {
            style = this.styleSet.getStyleFor(new CellReference(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn()), content, isSetHeaderStyle);
        }
        return this.merge(cellRangeAddress, content, style);
    }

    public ExcelWriter merge(CellRangeAddress cellRangeAddress, Object content, CellStyle cellStyle) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        RsCell.mergingCells(this.getSheet(), cellRangeAddress, cellStyle);
        if (null != content) {
            Cell cell = this.getOrCreateCell(cellRangeAddress.getFirstColumn(), cellRangeAddress.getFirstRow());
            RsCell.setCellValue(cell, content, cellStyle, this.cellEditor);
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        return this.write(data, 0 == this.getCurrentRow());
    }

    public ExcelWriter write(Iterable<?> data, boolean isWriteKeyAsHead) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        boolean isFirst = true;
        for (Object object : data) {
            this.writeRow(object, isFirst && isWriteKeyAsHead);
            if (!isFirst) continue;
            isFirst = false;
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data, Comparator<String> comparator) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        boolean isFirstRow = true;
        for (Object obj : data) {
            Map<String, Object> map;
            if (obj instanceof Map) {
                map = new TreeMap(comparator);
                map.putAll((Map)obj);
            } else {
                map = RsBean.beanToMap(obj, new TreeMap<String, Object>(comparator), false, false);
            }
            this.writeRow(map, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    public ExcelWriter writeImg(File imgFile, int col1, int row1, int col2, int row2) {
        return this.writeImg(imgFile, 0, 0, 0, 0, col1, row1, col2, row2);
    }

    public ExcelWriter writeImg(File imgFile, int dx1, int dy1, int dx2, int dy2, int col1, int row1, int col2, int row2) {
        return this.writeImg(imgFile, 6, dx1, dy1, dx2, dy2, col1, row1, col2, row2);
    }

    public ExcelWriter writeImg(File imgFile, int imgType, int dx1, int dy1, int dx2, int dy2, int col1, int row1, int col2, int row2) {
        return this.writeImg(RsFile.readBytes(imgFile), imgType, dx1, dy1, dx2, dy2, col1, row1, col2, row2);
    }

    public ExcelWriter writeImg(byte[] pictureData, int imgType, int dx1, int dy1, int dx2, int dy2, int col1, int row1, int col2, int row2) {
        Drawing patriarch = this.sheet.createDrawingPatriarch();
        ClientAnchor anchor = this.workbook.getCreationHelper().createClientAnchor();
        anchor.setDx1(dx1);
        anchor.setDy1(dy1);
        anchor.setDx2(dx2);
        anchor.setDy2(dy2);
        anchor.setCol1(col1);
        anchor.setRow1(row1);
        anchor.setCol2(col2);
        anchor.setRow2(row2);
        patriarch.createPicture(anchor, this.workbook.addPicture(pictureData, imgType));
        return this;
    }

    public ExcelWriter writeHeadRow(Iterable<?> rowData) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        this.headLocationCache = new SafeConcurrentHashMap<String, Integer>();
        Row row = this.sheet.createRow(this.currentRow.getAndIncrement());
        int i = 0;
        for (Object value : rowData) {
            Cell cell = row.createCell(i);
            RsCell.setCellValue(cell, value, this.styleSet, true, this.cellEditor);
            this.headLocationCache.put(RsString.toString(value), i);
            ++i;
        }
        return this;
    }

    public ExcelWriter writeSecHeadRow(Iterable<?> rowData) {
        Row row = RsRow.getOrCreateRow(this.sheet, this.currentRow.getAndIncrement());
        Iterator<?> iterator = rowData.iterator();
        if (row.getLastCellNum() != 0) {
            for (int i = 0; i < this.workbook.getSpreadsheetVersion().getMaxColumns(); ++i) {
                Cell cell = row.getCell(i);
                if (cell != null) continue;
                if (iterator.hasNext()) {
                    cell = row.createCell(i);
                    RsCell.setCellValue(cell, iterator.next(), this.styleSet, true, this.cellEditor);
                    continue;
                }
                break;
            }
        } else {
            this.writeHeadRow(rowData);
        }
        return this;
    }

    public ExcelWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        Map<String, Object> rowMap;
        if (rowBean instanceof Map) {
            rowMap = RsMap.isNotEmpty(this.headerAlias) ? RsMap.newTreeMap((Map)rowBean, this.getCachedAliasComparator()) : (TreeMap)rowBean;
        } else {
            if (rowBean instanceof Iterable) {
                return this.writeRow((Iterable)rowBean);
            }
            if (rowBean instanceof Hyperlink) {
                return this.writeRow(RsList.of(rowBean), isWriteKeyAsHead);
            }
            if (RsBean.isReadableBean(rowBean.getClass())) {
                rowMap = RsMap.isEmpty(this.headerAlias) ? RsBean.beanToMap(rowBean, new LinkedHashMap<String, Object>(), false, false) : RsBean.beanToMap(rowBean, new TreeMap<String, Object>(this.getCachedAliasComparator()), false, false);
            } else {
                return this.writeRow(RsList.of(rowBean), isWriteKeyAsHead);
            }
        }
        return this.writeRow(rowMap, isWriteKeyAsHead);
    }

    public ExcelWriter writeRow(Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        if (RsMap.isEmpty(rowMap)) {
            return this.passCurrentRow();
        }
        Table<?, ?, ?> aliasTable = this.aliasTable(rowMap);
        if (isWriteKeyAsHead) {
            this.writeHeadRow(aliasTable.columnKeys());
            int i = 0;
            for (Object key : aliasTable.rowKeySet()) {
                this.headLocationCache.putIfAbsent(RsString.toString(key), i);
                ++i;
            }
        }
        if (RsMap.isNotEmpty(this.headLocationCache)) {
            Row row = RsRow.getOrCreateRow(this.sheet, this.currentRow.getAndIncrement());
            for (Table.Cell cell : aliasTable) {
                Integer location = this.headLocationCache.get(RsString.toString(cell.getRowKey()));
                if (null == location) {
                    location = this.headLocationCache.get(RsString.toString(cell.getColumnKey()));
                }
                if (null == location) continue;
                RsCell.setCellValue(RsCell.getOrCreateCell(row, location), cell.getValue(), this.styleSet, false, this.cellEditor);
            }
        } else {
            this.writeRow(aliasTable.values());
        }
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        RsRow.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet, false, this.cellEditor);
        return this;
    }

    public ExcelWriter writeCol(Map<?, ? extends Iterable<?>> colMap, boolean isWriteKeyAsHead) {
        return this.writeCol(colMap, 0, isWriteKeyAsHead);
    }

    public ExcelWriter writeCol(Map<?, ? extends Iterable<?>> colMap, int startColIndex, boolean isWriteKeyAsHead) {
        for (Object k : colMap.keySet()) {
            Iterable<?> v = colMap.get(k);
            if (v == null) continue;
            this.writeCol(isWriteKeyAsHead ? k : null, startColIndex, v, startColIndex != colMap.size() - 1);
            ++startColIndex;
        }
        return this;
    }

    public ExcelWriter writeCol(Object headerVal, Iterable<?> colData, boolean isResetRowIndex) {
        return this.writeCol(headerVal, 0, colData, isResetRowIndex);
    }

    public ExcelWriter writeCol(Object headerVal, int colIndex, Iterable<?> colData, boolean isResetRowIndex) {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        int currentRowIndex = this.currentRow.get();
        if (null != headerVal) {
            this.writeCellValue(colIndex, currentRowIndex, headerVal, true);
            ++currentRowIndex;
        }
        for (Object colDatum : colData) {
            this.writeCellValue(colIndex, currentRowIndex, colDatum);
            ++currentRowIndex;
        }
        if (!isResetRowIndex) {
            this.currentRow.set(currentRowIndex);
        }
        return this;
    }

    public ExcelWriter writeCellValue(String locationRef, Object value) {
        CellReference cellReference = new CellReference(locationRef);
        return this.writeCellValue(cellReference.getCol(), cellReference.getRow(), value);
    }

    public ExcelWriter writeCellValue(int x, int y, Object value) {
        return this.writeCellValue(x, y, value, false);
    }

    public ExcelWriter writeCellValue(int x, int y, Object value, boolean isHeader) {
        Cell cell = this.getOrCreateCell(x, y);
        RsCell.setCellValue(cell, value, this.styleSet, isHeader, this.cellEditor);
        return this;
    }

    public ExcelWriter setStyle(CellStyle style, String locationRef) {
        CellReference cellReference = new CellReference(locationRef);
        return this.setStyle(style, cellReference.getCol(), cellReference.getRow());
    }

    public ExcelWriter setStyle(CellStyle style, int x, int y) {
        Cell cell = this.getOrCreateCell(x, y);
        cell.setCellStyle(style);
        return this;
    }

    public ExcelWriter setRowStyle(int y, CellStyle style) {
        this.getOrCreateRow(y).setRowStyle(style);
        return this;
    }

    public ExcelWriter setRowStyleIfHasData(int y, CellStyle style) {
        if (y < 0) {
            throw new IllegalArgumentException("Invalid row number (" + y + ")");
        }
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.setStyle(style, i, y);
        }
        return this;
    }

    public ExcelWriter setColumnStyle(int x, CellStyle style) {
        this.sheet.setDefaultColumnStyle(x, style);
        return this;
    }

    public ExcelWriter setColumnStyleIfHasData(int x, int y, CellStyle style) {
        if (x < 0) {
            throw new IllegalArgumentException("Invalid column number (" + x + ")");
        }
        if (y < 0) {
            throw new IllegalArgumentException("Invalid row number (" + y + ")");
        }
        int rowCount = this.getRowCount();
        for (int i = y; i < rowCount; ++i) {
            this.setStyle(style, x, i);
        }
        return this;
    }

    public ExcelWriter flush() throws IORuntimeException {
        return this.flush(this.destFile);
    }

    public ExcelWriter flush(File destFile) throws IORuntimeException {
        Assert.notNull(destFile, "[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", new Object[0]);
        return this.flush(RsFile.getOutputStream(destFile), true);
    }

    public ExcelWriter flush(OutputStream out) throws IORuntimeException {
        return this.flush(out, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExcelWriter flush(OutputStream out, boolean isCloseOut) throws IORuntimeException {
        Assert.isFalse(this.isClosed, "ExcelWriter has been closed!", new Object[0]);
        try {
            this.workbook.write(out);
            out.flush();
            if (!isCloseOut) return this;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                RsIo.closeQuietly(out);
                throw throwable;
            }
        }
        RsIo.closeQuietly(out);
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        super.close();
        this.currentRow.set(0);
        this.styleSet = null;
    }

    private Table<?, ?, ?> aliasTable(Map<?, ?> rowMap) {
        RowKeyTable filteredTable = new RowKeyTable(new LinkedHashMap(), TableMap::new);
        if (RsMap.isEmpty(this.headerAlias)) {
            rowMap.forEach((key, value) -> filteredTable.put(key, key, value));
        } else {
            rowMap.forEach((key, value) -> {
                String aliasName = (String)this.headerAlias.get(RsString.toString(key));
                if (null != aliasName) {
                    filteredTable.put(key, aliasName, value);
                } else if (!this.onlyAlias) {
                    filteredTable.put(key, key, value);
                }
            });
        }
        return filteredTable;
    }

    private Comparator<String> getCachedAliasComparator() {
        if (RsMap.isEmpty(this.headerAlias)) {
            return null;
        }
        Comparator<String> aliasComparator = this.aliasComparator;
        if (null == aliasComparator) {
            Set keySet = this.headerAlias.keySet();
            this.aliasComparator = aliasComparator = new IndexedComparator<String>(keySet.toArray(new String[0]));
        }
        return aliasComparator;
    }
}

