/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.useragent;

import java.util.ArrayList;
import java.util.List;
import top.redscorpion.core.util.RsList;
import top.redscorpion.http.useragent.UserAgentInfo;

public class Platform
extends UserAgentInfo {
    private static final long serialVersionUID = 1L;
    public static final Platform UNKNOWN = new Platform("Unknown", null);
    public static final Platform IPHONE = new Platform("iPhone", "iphone");
    public static final Platform IPOD = new Platform("iPod", "ipod");
    public static final Platform IPAD = new Platform("iPad", "ipad");
    public static final Platform ANDROID = new Platform("Android", "android");
    public static final Platform GOOGLE_TV = new Platform("GoogleTV", "googletv");
    public static final Platform WINDOWS_PHONE = new Platform("Windows Phone", "windows (ce|phone|mobile)( os)?");
    public static final List<Platform> MOBILE_PLATFORMS = RsList.view(WINDOWS_PHONE, IPAD, IPOD, IPHONE, new Platform("Android", "XiaoMi|MI\\s+"), ANDROID, GOOGLE_TV, new Platform("htcFlyer", "htc_flyer"), new Platform("Symbian", "symbian(os)?"), new Platform("Blackberry", "blackberry"));
    public static final List<Platform> DESKTOP_PLATFORMS = RsList.view(new Platform("Windows", "windows"), new Platform("Mac", "(macintosh|darwin)"), new Platform("Linux", "linux"), new Platform("Wii", "wii"), new Platform("Playstation", "playstation"), new Platform("Java", "java"));
    public static final List<Platform> PLATFORMS = new ArrayList<Platform>(13);

    public Platform(String name, String regex) {
        super(name, regex);
    }

    public boolean isMobile() {
        return MOBILE_PLATFORMS.contains(this);
    }

    public boolean isIphoneOrIpod() {
        return this.equals(IPHONE) || this.equals(IPOD);
    }

    public boolean isIpad() {
        return this.equals(IPAD);
    }

    public boolean isIos() {
        return this.isIphoneOrIpod() || this.isIpad();
    }

    public boolean isAndroid() {
        return this.equals(ANDROID) || this.equals(GOOGLE_TV);
    }

    static {
        PLATFORMS.addAll(MOBILE_PLATFORMS);
        PLATFORMS.addAll(DESKTOP_PLATFORMS);
    }
}

