/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.meta;

import java.util.List;
import java.util.Map;
import top.redscorpion.core.map.CaseInsensitiveMap;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.meta.HeaderName;

public class RsHttpHeader {
    public static List<String> headerList(Map<String, List<String>> headers, String name) {
        if (RsString.isBlank(name)) {
            return null;
        }
        CaseInsensitiveMap<String, List<String>> headersIgnoreCase = new CaseInsensitiveMap<String, List<String>>(headers);
        return (List)headersIgnoreCase.get(name.trim());
    }

    public static String getFileNameFromDisposition(Map<String, List<String>> headers, String paramName) {
        paramName = RsObject.defaultIfNull(paramName, "filename");
        List<String> dispositions = RsHttpHeader.headerList(headers, HeaderName.CONTENT_DISPOSITION.getValue());
        String fileName = null;
        if (RsColl.isNotEmpty(dispositions) && !RsString.endWith((CharSequence)(fileName = RsHttpHeader.getFileNameFromDispositions(dispositions, RsString.addSuffixIfNot(paramName, "*"))), "*") && RsString.isBlank(fileName)) {
            fileName = RsHttpHeader.getFileNameFromDispositions(dispositions, paramName);
        }
        return fileName;
    }

    private static String getFileNameFromDispositions(List<String> dispositions, String paramName) {
        String fileName = null;
        for (String disposition : dispositions) {
            fileName = RsRegular.getGroup1(paramName + "=\"(.*?)\"", (CharSequence)disposition);
            if (!RsString.isNotBlank(fileName)) continue;
            break;
        }
        return fileName;
    }
}

