/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.okhttp;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.client.ClientConfig;
import top.redscorpion.http.client.Request;
import top.redscorpion.http.client.Response;
import top.redscorpion.http.client.body.HttpBody;
import top.redscorpion.http.client.engine.ClientEngine;
import top.redscorpion.http.client.engine.okhttp.BasicProxyAuthenticator;
import top.redscorpion.http.client.engine.okhttp.OkHttpRequestBody;
import top.redscorpion.http.client.engine.okhttp.OkHttpResponse;
import top.redscorpion.http.proxy.HttpProxy;
import top.redscorpion.http.ssl.SSLInfo;

public class OkHttpEngine
implements ClientEngine {
    private ClientConfig config;
    private OkHttpClient client;

    public OkHttpEngine() {
        Assert.notNull(OkHttpClient.class);
    }

    @Override
    public OkHttpEngine init(ClientConfig config) {
        this.config = config;
        this.client = null;
        return this;
    }

    @Override
    public Response send(Request message) {
        okhttp3.Response response;
        this.initEngine();
        try {
            response = this.client.newCall(OkHttpEngine.buildRequest(message)).execute();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return new OkHttpResponse(response, message.charset());
    }

    @Override
    public Object getRawEngine() {
        return this.client;
    }

    @Override
    public void close() {
    }

    private void initEngine() {
        SSLInfo sslInfo;
        int readTimeout;
        if (null != this.client) {
            return;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ClientConfig conf = RsObject.defaultIfNull(this.config, ClientConfig::of);
        int connectionTimeout = conf.getConnectionTimeout();
        if (connectionTimeout > 0) {
            builder.connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = conf.getReadTimeout()) > 0) {
            builder.readTimeout((long)conf.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)conf.getReadTimeout(), TimeUnit.MILLISECONDS);
        }
        if (null != (sslInfo = conf.getSslInfo())) {
            SSLSocketFactory socketFactory = sslInfo.getSocketFactory();
            X509TrustManager trustManager = sslInfo.getTrustManager();
            if (null != socketFactory && null != trustManager) {
                builder.sslSocketFactory(socketFactory, trustManager);
            }
        }
        OkHttpEngine.setProxy(builder, conf);
        builder.followRedirects(false);
        this.client = builder.build();
    }

    private static okhttp3.Request buildRequest(Request message) {
        Request.Builder builder = new Request.Builder().url(message.handledUrl().toUrl());
        String method = message.method().name();
        HttpBody body = message.handledBody();
        if (null != body) {
            builder.method(method, (RequestBody)new OkHttpRequestBody(body));
        } else {
            builder.method(method, null);
        }
        message.headers().forEach((key, values) -> values.forEach(value -> builder.addHeader(key, value)));
        return builder.build();
    }

    private static void setProxy(OkHttpClient.Builder builder, ClientConfig config) {
        HttpProxy proxy = config.getProxy();
        if (null != proxy) {
            builder.setProxy$okhttp((Proxy)proxy);
            PasswordAuthentication auth = proxy.getAuth();
            if (null != auth) {
                builder.setProxyAuthenticator$okhttp((Authenticator)new BasicProxyAuthenticator(auth));
            }
        }
    }
}

