/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.engine.httpclient5;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.http.HttpException;
import top.redscorpion.http.RsHttp;
import top.redscorpion.http.client.Response;

public class HttpClient5Response
implements Response {
    private final ClassicHttpResponse rawRes;
    private final Charset requestCharset;

    public HttpClient5Response(ClassicHttpResponse rawRes, Charset requestCharset) {
        this.rawRes = rawRes;
        this.requestCharset = requestCharset;
    }

    @Override
    public int getStatus() {
        return this.rawRes.getCode();
    }

    @Override
    public String header(String name) {
        Header[] headers = this.rawRes.getHeaders(name);
        if (RsArray.isNotEmpty(headers)) {
            return headers[0].getValue();
        }
        return null;
    }

    @Override
    public Map<String, List<String>> headers() {
        Header[] headers = this.rawRes.getHeaders();
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(headers.length, 1.0f);
        for (Header header : headers) {
            List valueList = result.computeIfAbsent(header.getName(), k -> new ArrayList());
            valueList.add(header.getValue());
        }
        return result;
    }

    @Override
    public long contentLength() {
        return this.rawRes.getEntity().getContentLength();
    }

    @Override
    public Charset charset() {
        return RsObject.defaultIfNull(Response.super.charset(), this.requestCharset);
    }

    @Override
    public InputStream bodyStream() {
        try {
            return this.rawRes.getEntity().getContent();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public String bodyStr() throws HttpException {
        try {
            return EntityUtils.toString((HttpEntity)this.rawRes.getEntity(), (Charset)this.charset());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ParseException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.rawRes.close();
    }

    public String toString() {
        return RsHttp.toString(this);
    }
}

