/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client.body;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.http.HttpGlobalConfig;
import top.redscorpion.http.client.body.AbstractFormBody;
import top.redscorpion.http.client.body.MultipartOutputStream;
import top.redscorpion.http.meta.ContentType;

public class MultipartBody
extends AbstractFormBody<MultipartBody> {
    private static final String CONTENT_TYPE_MULTIPART_PREFIX = ContentType.MULTIPART.getValue() + "; boundary=";
    private final String boundary;

    public static MultipartBody of(Map<String, Object> form, Charset charset) {
        return MultipartBody.of(form, charset, HttpGlobalConfig.getBoundary());
    }

    public static MultipartBody of(Map<String, Object> form, Charset charset, String boundary) {
        return new MultipartBody(form, charset, boundary);
    }

    public MultipartBody(Map<String, Object> form, Charset charset, String boundary) {
        super(form, charset);
        this.boundary = boundary;
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE_MULTIPART_PREFIX + this.boundary;
    }

    @Override
    public String getContentType(Charset charset) {
        return this.getContentType();
    }

    @Override
    public void write(OutputStream out) {
        MultipartOutputStream stream = new MultipartOutputStream(out, this.charset, this.boundary);
        if (RsMap.isNotEmpty(this.form)) {
            this.form.forEach(stream::write);
        }
        stream.finish();
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(out);
        return RsIo.toStr(out, this.charset);
    }
}

