/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http.client;

import java.net.HttpCookie;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsList;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.RsHttp;
import top.redscorpion.http.meta.HeaderName;

public interface HeaderOperation<T extends HeaderOperation<T>> {
    public Map<String, ? extends Collection<String>> headers();

    public T header(String var1, String var2, boolean var3);

    default public String header(HeaderName headerName) {
        return this.header(headerName.getValue());
    }

    default public String header(String name) {
        return RsHttp.header(this.headers(), name);
    }

    default public T header(HeaderName name, String value, boolean isOverride) {
        return this.header(name.toString(), value, isOverride);
    }

    default public T header(HeaderName name, String value) {
        return this.header(name.toString(), value, true);
    }

    default public T header(String name, String value) {
        return this.header(name, value, true);
    }

    default public T header(Map<String, ? extends Collection<String>> headerMap, boolean isOverride) {
        if (RsMap.isNotEmpty(headerMap)) {
            for (Map.Entry<String, ? extends Collection<String>> entry : headerMap.entrySet()) {
                String name = entry.getKey();
                for (String value : entry.getValue()) {
                    this.header(name, RsString.toStringOrEmpty(value), isOverride);
                }
            }
        }
        return (T)this;
    }

    default public T header(Map<String, String> headerMap) {
        if (RsMap.isEmpty(headerMap)) {
            return (T)this;
        }
        LinkedHashMap headerMaps = new LinkedHashMap(this.headers().size());
        headerMap.forEach((key, value) -> headerMaps.put(key, RsList.of(value)));
        return this.header(headerMaps, true);
    }

    default public T contentType(String contentType) {
        this.header(HeaderName.CONTENT_TYPE, contentType);
        return (T)this;
    }

    default public T keepAlive(boolean isKeepAlive) {
        this.header(HeaderName.CONNECTION, isKeepAlive ? "Keep-Alive" : "Close");
        return (T)this;
    }

    default public long contentLength() {
        long contentLength = RsConvert.toLong(this.header(HeaderName.CONTENT_LENGTH), -1L);
        if (contentLength > 0L && (this.isChunked() || RsString.isNotBlank(this.contentEncoding()))) {
            contentLength = -1L;
        }
        return contentLength;
    }

    default public boolean isChunked() {
        return "Chunked".equalsIgnoreCase(this.header(HeaderName.TRANSFER_ENCODING));
    }

    default public String contentEncoding() {
        return this.header(HeaderName.CONTENT_ENCODING);
    }

    default public T bearerAuth(String token) {
        return this.auth("Bearer " + token);
    }

    default public T auth(String content) {
        this.header(HeaderName.AUTHORIZATION, content, true);
        return (T)this;
    }

    default public T proxyAuth(String content) {
        this.header(HeaderName.PROXY_AUTHORIZATION, content, true);
        return (T)this;
    }

    default public T cookie(Collection<HttpCookie> cookies) {
        return this.cookie(RsColl.isEmpty(cookies) ? null : cookies.toArray(new HttpCookie[0]));
    }

    default public T cookie(HttpCookie ... cookies) {
        if (RsArray.isEmpty(cookies)) {
            return this.disableCookie();
        }
        return this.cookie(RsArray.join(cookies, (CharSequence)"; "));
    }

    default public T cookie(String cookie) {
        return this.header(HeaderName.COOKIE, cookie, true);
    }

    default public T disableCookie() {
        return this.cookie("");
    }

    default public T enableDefaultCookie() {
        return this.cookie((String)null);
    }
}

