/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.redscorpion.core.util.RsColl;
import top.redscorpion.core.util.RsMap;
import top.redscorpion.core.util.RsString;
import top.redscorpion.http.meta.HeaderName;

public enum GlobalHeaders {
    INSTANCE;

    final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    private GlobalHeaders() {
        this.putDefault(false);
    }

    public GlobalHeaders putDefault(boolean isReset) {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        System.setProperty("jdk.tls.allowUnsafeServerCertChange", "true");
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
        if (isReset) {
            this.headers.clear();
        }
        this.header(HeaderName.ACCEPT, "*/*", true);
        this.header(HeaderName.ACCEPT_ENCODING, "gzip, deflate", true);
        this.header(HeaderName.USER_AGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 RS", true);
        return this;
    }

    public String header(String name) {
        List<String> values = this.headerList(name);
        if (RsColl.isEmpty(values)) {
            return null;
        }
        return values.get(0);
    }

    public List<String> headerList(String name) {
        if (RsString.isBlank(name)) {
            return null;
        }
        return this.headers.get(name.trim());
    }

    public String header(HeaderName name) {
        if (null == name) {
            return null;
        }
        return this.header(name.toString());
    }

    public synchronized GlobalHeaders header(String name, String value, boolean isOverride) {
        if (null != name && null != value) {
            List<String> values = this.headers.get(name.trim());
            if (isOverride || RsColl.isEmpty(values)) {
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value);
                this.headers.put(name.trim(), valueList);
            } else {
                values.add(value.trim());
            }
        }
        return this;
    }

    public GlobalHeaders header(HeaderName name, String value, boolean isOverride) {
        return this.header(name.toString(), value, isOverride);
    }

    public GlobalHeaders header(HeaderName name, String value) {
        return this.header(name.toString(), value, true);
    }

    public GlobalHeaders header(String name, String value) {
        return this.header(name, value, true);
    }

    public GlobalHeaders header(Map<String, List<String>> headers) {
        if (RsMap.isEmpty(headers)) {
            return this;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                this.header(name, RsString.toStringOrEmpty(value), false);
            }
        }
        return this;
    }

    public synchronized GlobalHeaders removeHeader(String name) {
        if (name != null) {
            this.headers.remove(name.trim());
        }
        return this;
    }

    public GlobalHeaders removeHeader(HeaderName name) {
        return this.removeHeader(name.toString());
    }

    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public synchronized GlobalHeaders clearHeaders() {
        this.headers.clear();
        return this;
    }
}

