/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.http;

import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import top.redscorpion.core.compress.InflaterInputStream;
import top.redscorpion.core.map.CaseInsensitiveMap;
import top.redscorpion.core.reflect.RsConstructor;

public enum GlobalCompressStreamRegister {
    INSTANCE;

    private final Map<String, Class<? extends InputStream>> compressMap = new CaseInsensitiveMap<String, Class<? extends InputStream>>();

    private GlobalCompressStreamRegister() {
        this.compressMap.put("gzip", GZIPInputStream.class);
        this.compressMap.put("deflate", InflaterInputStream.class);
    }

    public InputStream wrapStream(InputStream in, String contentEncoding) {
        Class<? extends InputStream> streamClass = this.get(contentEncoding);
        if (null != streamClass) {
            try {
                return RsConstructor.newInstance(streamClass, in);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return in;
    }

    public Class<? extends InputStream> get(String contentEncoding) {
        return this.compressMap.get(contentEncoding);
    }

    public synchronized void register(String contentEncoding, Class<? extends InputStream> streamClass) {
        this.compressMap.put(contentEncoding, streamClass);
    }

    public synchronized void unRegister(String contentEncoding) {
        this.compressMap.remove(contentEncoding);
    }
}

