/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.extra.setting;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import top.redscorpion.core.io.LineReader;
import top.redscorpion.core.io.resource.Resource;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsSystem;
import top.redscorpion.extra.setting.GroupedMap;
import top.redscorpion.log.Log;

public class SettingLoader {
    private static final Log log = Log.get();
    private static final char COMMENT_FLAG_PRE = '#';
    private char assignFlag = (char)61;
    private String varRegex = "\\$\\{(.*?)\\}";
    private final Charset charset;
    private final boolean isUseVariable;
    private final GroupedMap groupedMap;

    public SettingLoader(GroupedMap groupedMap) {
        this(groupedMap, RsCharset.UTF_8, false);
    }

    public SettingLoader(GroupedMap groupedMap, Charset charset, boolean isUseVariable) {
        this.groupedMap = groupedMap;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Resource resource) {
        if (resource == null) {
            throw new NullPointerException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", resource);
        InputStream settingStream = null;
        try {
            settingStream = resource.getStream();
            this.load(settingStream);
        }
        catch (Exception e) {
            boolean bl;
            try {
                log.error(e, "Load setting error!", new Object[0]);
                bl = false;
            }
            catch (Throwable throwable) {
                RsIo.closeQuietly(settingStream);
                throw throwable;
            }
            RsIo.closeQuietly(settingStream);
            return bl;
        }
        RsIo.closeQuietly(settingStream);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream settingStream) throws IOException {
        this.groupedMap.clear();
        LineReader reader = null;
        try {
            String line;
            reader = new LineReader(settingStream, this.charset);
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (RsString.isBlank(line = RsString.trim(line)) || RsString.startWith((CharSequence)line, '#')) continue;
                if (RsString.isWrap(line, '[', ']')) {
                    group = RsString.trim(line.substring(1, line.length() - 1));
                    continue;
                }
                String[] keyValue = RsSplit.split(line, String.valueOf(this.assignFlag), 2, true, false).toArray(new String[0]);
                if (keyValue.length < 2) continue;
                String value = keyValue[1];
                if (this.isUseVariable) {
                    value = this.replaceVar(group, value);
                }
                this.groupedMap.put(group, RsString.trim(keyValue[0]), value);
            }
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly(reader);
            throw throwable;
        }
        RsIo.closeQuietly(reader);
    }

    public void setVarRegex(String regex) {
        this.varRegex = regex;
    }

    public void setAssignFlag(char assignFlag) {
        this.assignFlag = assignFlag;
    }

    public void store(String absolutePath) {
        this.store(RsFile.touch(absolutePath));
    }

    public void store(File file) {
        Assert.notNull(file, "File to store must be not null !", new Object[0]);
        log.debug("Store Setting to [{}]...", file.getAbsolutePath());
        PrintWriter writer = null;
        try {
            writer = RsFile.getPrintWriter(file, this.charset, false);
            this.store(writer);
        }
        catch (Throwable throwable) {
            RsIo.closeQuietly(writer);
            throw throwable;
        }
        RsIo.closeQuietly(writer);
    }

    private synchronized void store(PrintWriter writer) {
        for (Map.Entry<String, LinkedHashMap<String, String>> groupEntry : this.groupedMap.entrySet()) {
            writer.println(RsString.format("{}{}{}", Character.valueOf('['), groupEntry.getKey(), Character.valueOf(']')));
            for (Map.Entry<String, String> entry : groupEntry.getValue().entrySet()) {
                writer.println(RsString.format("{} {} {}", entry.getKey(), Character.valueOf(this.assignFlag), entry.getValue()));
            }
        }
    }

    private String replaceVar(String group, String value) {
        Set vars = RsRegular.findAll(this.varRegex, (CharSequence)value, 0, new HashSet());
        for (String var : vars) {
            List<String> groupAndKey;
            String key = RsRegular.get(this.varRegex, (CharSequence)var, 1);
            if (!RsString.isNotBlank(key)) continue;
            String varValue = this.groupedMap.get(group, key);
            if (null == varValue && (groupAndKey = RsSplit.split(key, ".", 2, true, false)).size() > 1) {
                varValue = this.groupedMap.get(groupAndKey.get(0), groupAndKey.get(1));
            }
            if (null == varValue) {
                varValue = RsSystem.get(key);
            }
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }
}

