/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.reflect.ModifierType;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsReflect;

public class RsModifier {
    public static boolean hasModifier(Member member, ModifierType ... modifierTypes) {
        if (null == member || RsArray.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (member.getModifiers() & ModifierType.orToInt(modifierTypes));
    }

    public static boolean isDefault(Method method) {
        return null != method && method.isDefault();
    }

    public static boolean isPublic(Member member) {
        return null != member && Modifier.isPublic(member.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return null != member && Modifier.isStatic(member.getModifiers());
    }

    public static boolean isAbstract(Member member) {
        return null != member && Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return null != clazz && Modifier.isAbstract(clazz.getModifiers());
    }

    public static void removeFinalModify(Field field) {
        Field modifiersField;
        if (!RsModifier.hasModifier(field, ModifierType.FINAL)) {
            return;
        }
        RsReflect.setAccessible(field);
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            throw new RsException(e, "Field [modifiers] not exist!", new Object[0]);
        }
        try {
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (IllegalAccessException e) {
            throw new RsException(e, "IllegalAccess for [{}.{}]", field.getDeclaringClass(), field.getName());
        }
    }
}

