/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsIter;
import top.redscorpion.core.util.RsMapGet;
import top.redscorpion.core.util.RsObject;

public class RsMap
extends RsMapGet {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !RsMap.isEmpty(map);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isLinked) {
        int initialCapacity = (int)((float)size / 0.75f) + 1;
        return isLinked ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isLinked) {
        return RsMap.newHashMap(16, isLinked);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        if (RsMap.isNotEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        return RsMap.createMap(mapType, HashMap::new);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType, Supplier<Map<K, V>> defaultMap) {
        Map result = null;
        if (null != mapType && !mapType.isAssignableFrom(AbstractMap.class)) {
            try {
                result = (Map)RsConstructor.newInstanceIfPossible(mapType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == result) {
            result = defaultMap.get();
        }
        if (!result.isEmpty()) {
            result.clear();
        }
        return result;
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return RsMap.of(key, value, false);
    }

    public static <K, V> HashMap<K, V> of(K key, V value, boolean isOrder) {
        HashMap<K, V> map = RsMap.newHashMap(isOrder);
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> edit(Map<K, V> map, UnaryOperator<Map.Entry<K, V>> editor) {
        if (null == map || null == editor) {
            return map;
        }
        Map map2 = RsMap.createMap(map.getClass(), () -> new HashMap(map.size(), 1.0f));
        if (RsMap.isEmpty(map)) {
            return map2;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry modified = (Map.Entry)editor.apply(entry);
            if (null == modified) continue;
            map2.put(modified.getKey(), modified.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        if (null == map || null == predicate) {
            return map;
        }
        return RsMap.edit(map, t -> predicate.test((Map.Entry)t) ? t : null);
    }

    public static <K, V> Map<V, K> inverse(Map<K, V> map) {
        Map result = RsMap.createMap(map.getClass());
        map.forEach((key, value) -> result.put(value, key));
        return result;
    }

    public static <K, V> Map<K, V> view(Map<K, V> map) {
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> getAny(Map<K, V> map, K ... keys) {
        return RsMap.filter(map, entry -> RsArray.contains(keys, entry.getKey()));
    }

    public static <K, V> Map<K, V> removeByValue(Map<K, V> map, V value) {
        return RsMap.removeIf(map, entry -> RsObject.equals(value, entry.getValue()));
    }

    public static <K, V> Map<K, V> removeIf(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        if (RsMap.isEmpty(map)) {
            return map;
        }
        map.entrySet().removeIf(predicate);
        return map;
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return RsMap.entry(key, value, true);
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value, boolean isImmutable) {
        return isImmutable ? new AbstractMap.SimpleImmutableEntry<K, V>(key, value) : new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterable<V> iterable, Function<V, K> keyMapper) {
        return RsMap.putAll(resultMap, iterable, keyMapper, Function.identity());
    }

    public static <T, K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterable<T> iterable, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return RsMap.putAll(resultMap, RsIter.getIter(iterable), keyMapper, valueMapper);
    }

    public static <T, K, V> Map<K, V> putAll(Map<K, V> resultMap, Iterator<T> iterator, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        if (null == resultMap) {
            resultMap = new HashMap();
        }
        if (RsObject.isNull(iterator)) {
            return resultMap;
        }
        while (iterator.hasNext()) {
            T value = iterator.next();
            resultMap.put(keyMapper.apply(value), valueMapper.apply(value));
        }
        return resultMap;
    }

    public static <K, V> V computeIfAbsentForJdk8(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        V res;
        V value = map.get(key);
        if (null == value && null != (res = map.putIfAbsent(key, value = mappingFunction.apply(key)))) {
            return res;
        }
        return value;
    }

    public static <K, V> V firstMatchValue(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        Map.Entry<K, V> kvEntry = RsMap.firstMatch(map, predicate);
        if (null != kvEntry) {
            return kvEntry.getValue();
        }
        return null;
    }

    public static <K, V> Map.Entry<K, V> firstMatch(Map<K, V> map, Predicate<Map.Entry<K, V>> predicate) {
        if (RsMap.isNotEmpty(map)) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (!predicate.test(entry)) continue;
                return entry;
            }
        }
        return null;
    }
}

