/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsValidator;

public class RsList {
    @SafeVarargs
    public static <T> ArrayList<T> of(T ... values) {
        if (RsArray.isEmpty(values)) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    @SafeVarargs
    public static <T> LinkedList<T> ofLinked(T ... values) {
        LinkedList list = new LinkedList();
        if (RsArray.isNotEmpty(values)) {
            Collections.addAll(list, values);
        }
        return list;
    }

    public static <T> List<T> of(boolean isLinked) {
        return isLinked ? RsList.ofLinked(new Object[0]) : RsList.of(new Object[0]);
    }

    public static <T> List<T> of(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return RsList.of(isLinked);
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return isLinked ? new LinkedList(collection) : new ArrayList(collection);
        }
        return RsList.of(isLinked, iterable.iterator());
    }

    public static <T> List<T> of(boolean isLinked, Iterator<T> iter) {
        List<T> list = RsList.of(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> ArrayList<T> of(Iterable<T> iterable) {
        return (ArrayList)RsList.of(false, iterable);
    }

    public static <T> ArrayList<T> of(Iterator<T> iterator) {
        return (ArrayList)RsList.of(false, iterator);
    }

    @SafeVarargs
    public static <T> List<T> view(T ... ts) {
        return RsList.view(RsList.of(ts));
    }

    public static <T> List<T> view(List<T> ts) {
        if (RsArray.isEmpty(ts)) {
            return RsList.empty();
        }
        return Collections.unmodifiableList(ts);
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element) {
        return RsList.setOrPadding(list, index, element, null);
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element, T paddingElement) {
        return RsList.setOrPadding(list, index, element, paddingElement, (list.size() + 1) * 10);
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element, T paddingElement, int indexLimit) {
        Assert.notNull(list, "List must be not null !", new Object[0]);
        int size = list.size();
        if (index < size) {
            list.set(index, element);
        } else {
            if (indexLimit > 0) {
                RsValidator.checkIndexLimit(index, indexLimit);
            }
            for (int i = size; i < index; ++i) {
                list.add(paddingElement);
            }
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> sub(List<T> list, int begionInclude, int endExclude, int step) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list.size();
        if (begionInclude < 0) {
            begionInclude += size;
        }
        if (endExclude < 0) {
            endExclude += size;
        }
        if (begionInclude == size) {
            return new ArrayList(0);
        }
        if (begionInclude > endExclude) {
            int tmp = begionInclude;
            begionInclude = endExclude;
            endExclude = tmp;
        }
        if (endExclude > size) {
            if (begionInclude >= size) {
                return new ArrayList(0);
            }
            endExclude = size;
        }
        if (step < 1) {
            step = 1;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = begionInclude; i < endExclude; i += step) {
            result.add(list.get(i));
        }
        return result;
    }
}

