/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.io.file.FileWriter;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.Console;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsCharset;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsDate;
import top.redscorpion.core.util.RsFileName;
import top.redscorpion.core.util.RsId;
import top.redscorpion.core.util.RsIo;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsPath;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsResource;
import top.redscorpion.core.util.RsSplit;
import top.redscorpion.core.util.RsString;
import top.redscorpion.core.util.RsThread;
import top.redscorpion.core.util.RsUrl;

public class RsFile
extends RsPath {
    private static final Pattern PATTERN_PATH_ABSOLUTE = Pattern.compile("^[a-zA-Z]:([/\\\\].*)?", 32);

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static File file(String path) {
        if (null == path) {
            return null;
        }
        return new File(RsFile.getAbsolutePath(path));
    }

    public static File file(File parent, String path) {
        if (RsString.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return RsFile.checkSlip(parent, RsFile.buildFile(parent, path));
    }

    public static File file(URL url) {
        return new File(RsUrl.toUri(url));
    }

    public static File touch(String path) throws IORuntimeException {
        if (path == null) {
            return null;
        }
        return RsFile.touch(RsFile.file(path));
    }

    public static File touch(File file) throws IORuntimeException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            RsFile.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                throw new IORuntimeException(e);
            }
        }
        return file;
    }

    public static File mkParentDirs(File file) {
        if (null == file) {
            return null;
        }
        return RsFile.mkdir(RsFile.getParent(file, 1));
    }

    public static void del(File file) throws IORuntimeException {
        Assert.notNull(file, "File must be not null!", new Object[0]);
        RsFile.del(file.toPath());
    }

    public static File mkdir(File dir) {
        if (dir == null) {
            return null;
        }
        if (!dir.exists()) {
            RsFile.mkdirsSafely(dir, 5, 1L);
        }
        return dir;
    }

    public static boolean mkdirsSafely(File dir, int tryCount, long sleepMillis) {
        if (dir == null) {
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        for (int i = 1; i <= tryCount; ++i) {
            dir.mkdirs();
            if (dir.exists()) {
                return true;
            }
            RsThread.sleep(sleepMillis);
        }
        return dir.exists();
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws IORuntimeException {
        try {
            File file = RsPath.createTempFile(prefix, suffix, null == dir ? null : dir.toPath()).toFile().getCanonicalFile();
            if (isReCreat) {
                file.delete();
                file.createNewFile();
            }
            return file;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static File copy(File src, File target, boolean isOverride) throws IORuntimeException {
        CopyOption[] copyOptionArray;
        Assert.notNull(src, "Src file must be not null!", new Object[0]);
        Assert.notNull(target, "target file must be not null!", new Object[0]);
        Path path = src.toPath();
        Path path2 = target.toPath();
        if (isOverride) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        return RsFile.copy(path, path2, copyOptionArray).toFile();
    }

    public static File rename(File file, String newName, boolean isOverride) {
        return RsFile.rename(file, newName, false, isOverride);
    }

    public static File rename(File file, String newName, boolean isRetainExt, boolean isOverride) {
        String extName;
        if (isRetainExt && RsString.isNotBlank(extName = RsFileName.extName(file))) {
            newName = newName.concat(".").concat(extName);
        }
        return RsFile.rename(file.toPath(), newName, isOverride).toFile();
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        String normalPath;
        if (path == null) {
            normalPath = "";
        } else {
            normalPath = RsFileName.normalize(path);
            if (RsFile.isAbsolutePath(normalPath)) {
                return normalPath;
            }
        }
        URL url = RsResource.getResourceUrl(normalPath, baseClass);
        if (null != url) {
            return RsFileName.normalize(RsUrl.getDecodedPath(url));
        }
        String classPath = RsClass.getClassPath();
        if (null == classPath) {
            return path;
        }
        return RsFileName.normalize(classPath.concat(Objects.requireNonNull(path)));
    }

    public static String getAbsolutePath(String path) {
        return RsFile.getAbsolutePath(path, null);
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isAbsolutePath(String path) {
        if (RsString.isEmpty(path)) {
            return false;
        }
        return '/' == path.charAt(0) || RsRegular.isMatch(PATTERN_PATH_ABSOLUTE, path);
    }

    public static boolean isFile(File file) {
        return null != file && file.isFile();
    }

    public static int lastIndexOfSeparator(String filePath) {
        if (RsString.isNotEmpty(filePath)) {
            int i = filePath.length();
            while (--i >= 0) {
                char c = filePath.charAt(i);
                if (!RsChar.isFileSeparator(c)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String normalize(String path) {
        return RsFileName.normalize(path);
    }

    public static BufferedInputStream getInputStream(File file) throws IORuntimeException {
        return RsIo.toBuffered(RsIo.toStream(file));
    }

    public static byte[] readBytes(File file) throws IORuntimeException {
        if (null == file) {
            return null;
        }
        return RsFile.readBytes(file.toPath());
    }

    public static BufferedOutputStream getOutputStream(File file) throws IORuntimeException {
        OutputStream out;
        try {
            out = Files.newOutputStream(RsFile.touch(file).toPath(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return RsIo.toBuffered(out);
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) throws IORuntimeException {
        return FileWriter.of(file, charset).getWriter(isAppend);
    }

    public static PrintWriter getPrintWriter(File file, Charset charset, boolean isAppend) throws IORuntimeException {
        return new PrintWriter(RsFile.getWriter(file, charset, isAppend));
    }

    public static File appendUtf8String(String content, String path) throws IORuntimeException {
        return RsFile.appendString(content, path, RsCharset.UTF_8);
    }

    public static File appendString(String content, String path, Charset charset) throws IORuntimeException {
        return RsFile.appendString(content, RsFile.touch(path), charset);
    }

    public static File appendString(String content, File file, Charset charset) throws IORuntimeException {
        return FileWriter.of(file, charset).append(content);
    }

    public static File getWebRoot() {
        String classPath = RsClass.getClassPath();
        Console.log(classPath);
        if (RsString.isNotBlank(classPath)) {
            return RsFile.getParent(RsFile.file(classPath), 2);
        }
        return null;
    }

    public static File getParent(File file, int level) {
        File parentFile;
        if (level < 1 || null == file) {
            return file;
        }
        try {
            parentFile = file.getCanonicalFile().getParentFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (1 == level) {
            return parentFile;
        }
        return RsFile.getParent(parentFile, level - 1);
    }

    public static File checkSlip(File parentFile, File file) throws IllegalArgumentException {
        if (null != parentFile && null != file && !RsFile.isSub(parentFile, file)) {
            throw new IllegalArgumentException(RsString.format("New file [{}] is outside of the parent dir: [{}]", file, parentFile));
        }
        return file;
    }

    public static String getMimeType(String filePath, String defaultValue) {
        return RsObject.defaultIfNull(RsFile.getMimeType(filePath), defaultValue);
    }

    public static String getMimeType(String filePath) {
        if (RsString.isBlank(filePath)) {
            return null;
        }
        if (RsString.endWith(filePath, ".css", true)) {
            return "text/css";
        }
        if (RsString.endWith(filePath, ".js", true)) {
            return "application/x-javascript";
        }
        if (RsString.endWith(filePath, ".rar", true)) {
            return "application/x-rar-compressed";
        }
        if (RsString.endWith(filePath, ".7z", true)) {
            return "application/x-7z-compressed";
        }
        if (RsString.endWith(filePath, ".wgt", true)) {
            return "application/widget";
        }
        if (RsString.endWith(filePath, ".webp", true)) {
            return "image/webp";
        }
        String contentType = URLConnection.getFileNameMap().getContentTypeFor(filePath);
        if (null == contentType) {
            contentType = RsFile.getMimeType(Paths.get(filePath, new String[0]));
        }
        return contentType;
    }

    public static boolean isSub(File parent, File sub) {
        Assert.notNull(parent);
        Assert.notNull(sub);
        return RsFile.isSub(parent.toPath(), sub.toPath());
    }

    private static File buildFile(File outFile, String fileName) {
        fileName = fileName.replace('\\', '/');
        if (!RsFile.isWindows() && fileName.lastIndexOf(47, fileName.length() - 2) > 0) {
            List<String> pathParts = RsSplit.split(fileName, "/", false, true);
            int lastPartIndex = pathParts.size() - 1;
            for (int i = 0; i < lastPartIndex; ++i) {
                outFile = new File(outFile, pathParts.get(i));
            }
            outFile.mkdirs();
            fileName = pathParts.get(lastPartIndex);
        }
        return new File(outFile, fileName);
    }

    public static void logOut(String path, String name, String message) {
        String id = RsId.nextIdStr();
        StringBuilder str = RsFile.logOutStart(id, name, message);
        RsFile.logOutEnd(id, path, str);
    }

    public static void logOut(String path, String name, String message, String strText) {
        String id = RsId.nextIdStr();
        StringBuilder str = RsFile.logOutStart(id, name, message);
        str.append(strText);
        RsFile.logOutEnd(id, path, str);
    }

    public static StringBuilder logOutStart(String idStr, String name, String message) {
        StringBuilder str = new StringBuilder();
        str.append(RsDate.formatNow());
        str.append("----");
        str.append(idStr);
        str.append("----Start----");
        str.append(name);
        str.append("----\n");
        str.append("Message\uff1a\n");
        if (RsString.isBlank(message)) {
            str.append("Succeeded if no prompt message is passed in.");
        } else {
            str.append(message);
        }
        return str;
    }

    public static void logOutEnd(String idStr, String path, StringBuilder str) {
        str.append("\n");
        str.append(RsDate.formatNow());
        str.append("----");
        str.append(idStr);
        str.append("----End------\n\n");
        if (RsString.isBlank(path)) {
            path = "./out-logs";
        }
        RsFile.appendUtf8String(str.toString(), path + "/" + RsDate.formatToday() + ".log");
    }
}

