/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.util;

import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.TripleTable;
import top.redscorpion.core.text.StringTrimer;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsString;

public class RsClassDesc {
    private static final TripleTable<Class<?>, Character, String> PRIMITIVE_TABLE = new TripleTable(9);

    public static Class<?> nameToClass(String name, boolean isInitialized, ClassLoader cl) {
        Assert.notNull(name, "Name must not be null", new Object[0]);
        name = RsString.trim(name, StringTrimer.TrimMode.SUFFIX, c -> '/' == c.charValue() || '.' == c.charValue());
        int c2 = 0;
        int index = name.indexOf(91);
        if (index > 0) {
            c2 = (name.length() - index) / 2;
            name = name.substring(0, index);
        }
        if (c2 > 0) {
            StringBuilder sb = new StringBuilder();
            while (c2-- > 0) {
                sb.append('[');
            }
            Class<?> clazz = PRIMITIVE_TABLE.getLeftByRight(name);
            if (null != clazz) {
                sb.append(PRIMITIVE_TABLE.getMiddleByLeft(clazz).charValue());
            } else {
                sb.append('L').append(name).append(';');
            }
            name = sb.toString();
        } else {
            Class<?> clazz = PRIMITIVE_TABLE.getLeftByRight(name);
            if (null != clazz) {
                return clazz;
            }
        }
        return RsClass.forName(name, isInitialized, cl);
    }
}

