/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text.placeholder;

import java.util.Map;
import top.redscorpion.core.lang.mutable.MutableEntry;
import top.redscorpion.core.map.reference.WeakConcurrentMap;
import top.redscorpion.core.text.placeholder.AbstractStringTemplate;
import top.redscorpion.core.text.placeholder.template.NamedPlaceholderStringTemplate;
import top.redscorpion.core.text.placeholder.template.SinglePlaceholderStringTemplate;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsString;

public class StringFormatter {
    private static final WeakConcurrentMap<Map.Entry<CharSequence, Object>, AbstractStringTemplate> CACHE = new WeakConcurrentMap();

    public static String format(String strPattern, Object ... argArray) {
        return StringFormatter.formatWith(strPattern, "{}", argArray);
    }

    public static String formatWith(String strPattern, String placeHolder, Object ... argArray) {
        if (RsString.isBlank(strPattern) || RsString.isBlank(placeHolder) || RsArray.isEmpty(argArray)) {
            return strPattern;
        }
        return ((SinglePlaceholderStringTemplate)CACHE.computeIfAbsent(MutableEntry.of(strPattern, placeHolder), k -> (SinglePlaceholderStringTemplate)AbstractStringTemplate.of(strPattern).placeholder(placeHolder).build())).format(argArray);
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        if (null == template) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return template.toString();
        }
        return ((NamedPlaceholderStringTemplate)CACHE.computeIfAbsent(MutableEntry.of(template, ignoreNull), k -> {
            NamedPlaceholderStringTemplate.Builder builder = AbstractStringTemplate.ofNamed(template.toString());
            if (ignoreNull) {
                builder.addFeatures(AbstractStringTemplate.Feature.FORMAT_NULL_VALUE_TO_WHOLE_PLACEHOLDER);
            } else {
                builder.addFeatures(AbstractStringTemplate.Feature.FORMAT_NULL_VALUE_TO_EMPTY);
            }
            return builder.build();
        })).format(map);
    }

    public static void clear() {
        CACHE.clear();
    }
}

