/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import top.redscorpion.core.collection.iter.ArrayIter;
import top.redscorpion.core.io.IORuntimeException;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsString;

public class StringJoiner
implements Appendable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Appendable appendable;
    private CharSequence delimiter;
    private CharSequence prefix;
    private CharSequence suffix;
    private boolean wrapElement;
    private NullMode nullMode = NullMode.NULL_STRING;
    private String emptyResult = "";
    private boolean hasContent;

    public static StringJoiner of(CharSequence delimiter) {
        return new StringJoiner(delimiter);
    }

    public static StringJoiner of(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return new StringJoiner(delimiter, prefix, suffix);
    }

    public StringJoiner(CharSequence delimiter) {
        this(null, delimiter);
    }

    public StringJoiner(Appendable appendable, CharSequence delimiter) {
        this(appendable, delimiter, null, null);
    }

    public StringJoiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this(null, delimiter, prefix, suffix);
    }

    public StringJoiner(Appendable appendable, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        if (null != appendable) {
            this.appendable = appendable;
            this.checkHasContent(appendable);
        }
        this.delimiter = delimiter;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public StringJoiner setWrapElement(boolean wrapElement) {
        this.wrapElement = wrapElement;
        return this;
    }

    public StringJoiner append(Object obj) {
        if (null == obj) {
            this.append((CharSequence)null);
        } else if (RsArray.isArray(obj)) {
            this.append(new ArrayIter(obj));
        } else if (obj instanceof Iterator) {
            this.append((Iterator)obj);
        } else if (obj instanceof Iterable) {
            this.append(((Iterable)obj).iterator());
        } else if (obj instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)obj;
            this.append(entry.getKey()).append(entry.getValue());
        } else {
            this.append(RsConvert.toStr(obj));
        }
        return this;
    }

    public <T> StringJoiner append(T[] array) {
        if (null == array) {
            return this;
        }
        return this.append(new ArrayIter<T>(array));
    }

    public <T> StringJoiner append(Iterator<T> iterator) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                this.append(iterator.next());
            }
        }
        return this;
    }

    @Override
    public StringJoiner append(CharSequence csq) {
        return this.append(csq, 0, RsString.length(csq));
    }

    @Override
    public StringJoiner append(CharSequence csq, int startInclude, int endExclude) {
        if (null == csq) {
            switch (this.nullMode) {
                case IGNORE: {
                    return this;
                }
                case TO_EMPTY: {
                    csq = "";
                    break;
                }
                case NULL_STRING: {
                    csq = "null";
                    endExclude = "null".length();
                }
            }
        }
        try {
            Appendable appendable = this.prepare();
            if (this.wrapElement && RsString.isNotEmpty(this.prefix)) {
                appendable.append(this.prefix);
            }
            appendable.append(csq, startInclude, endExclude);
            if (this.wrapElement && RsString.isNotEmpty(this.suffix)) {
                appendable.append(this.suffix);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public StringJoiner append(char c) {
        return this.append(String.valueOf(c));
    }

    public String toString() {
        if (null == this.appendable) {
            return this.emptyResult;
        }
        String result = this.appendable.toString();
        if (!this.wrapElement && RsString.isNotEmpty(this.suffix)) {
            result = result + this.suffix;
        }
        return result;
    }

    private Appendable prepare() throws IOException {
        if (this.hasContent) {
            if (null != this.delimiter) {
                this.appendable.append(this.delimiter);
            }
        } else {
            if (null == this.appendable) {
                this.appendable = new StringBuilder();
            }
            if (!this.wrapElement && RsString.isNotEmpty(this.prefix)) {
                this.appendable.append(this.prefix);
            }
            this.hasContent = true;
        }
        return this.appendable;
    }

    private void checkHasContent(Appendable appendable) {
        if (appendable instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)((Object)appendable);
            if (charSequence.length() > 0 && RsString.endWith(charSequence, this.delimiter)) {
                this.hasContent = true;
            }
        } else {
            String initStr = appendable.toString();
            if (RsString.isNotEmpty(initStr) && !RsString.endWith((CharSequence)initStr, this.delimiter)) {
                this.hasContent = true;
            }
        }
    }

    public static enum NullMode {
        IGNORE,
        TO_EMPTY,
        NULL_STRING;

    }
}

