/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.text;

import java.util.HashSet;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import top.redscorpion.core.text.NamingCase;
import top.redscorpion.core.text.StringRegionMatcher;
import top.redscorpion.core.text.StringRepeater;
import top.redscorpion.core.text.StringTrimer;
import top.redscorpion.core.text.StringValidator;
import top.redscorpion.core.text.finder.CharFinder;
import top.redscorpion.core.text.finder.CharMatcherFinder;
import top.redscorpion.core.text.finder.StringFinder;
import top.redscorpion.core.text.placeholder.StringFormatter;
import top.redscorpion.core.text.replacer.RangeReplacerByChar;
import top.redscorpion.core.text.replacer.SearchReplacer;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsChar;
import top.redscorpion.core.util.RsString;

public class CharSequenceHandle
extends StringValidator {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String SPACE = " ";

    public static String toString(Object obj) {
        return String.valueOf(obj);
    }

    public static String toStringOrNull(Object obj) {
        return null == obj ? null : obj.toString();
    }

    public static String toStringOrEmpty(Object obj) {
        return null == obj ? "" : obj.toString();
    }

    public static CharSequence emptyIfNull(CharSequence str) {
        return null == str ? "" : str;
    }

    public static <T extends CharSequence> T nullIfEmpty(T str) {
        return CharSequenceHandle.isEmpty(str) ? null : (T)str;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T str, T defaultValue) {
        return CharSequenceHandle.isEmpty(str) ? defaultValue : str;
    }

    public static String trim(CharSequence str) {
        return StringTrimer.TRIM_BLANK.apply(str);
    }

    public static String trimToNull(CharSequence str) {
        String trimStr = CharSequenceHandle.trim(str);
        return "".equals(trimStr) ? null : trimStr;
    }

    public static String trimPrefix(CharSequence str) {
        return StringTrimer.TRIM_PREFIX_BLANK.apply(str);
    }

    public static String trim(CharSequence str, StringTrimer.TrimMode mode, Predicate<Character> predicate) {
        return new StringTrimer(mode, predicate).apply(str);
    }

    public static boolean startWith(CharSequence str, char c) {
        if (CharSequenceHandle.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(0);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix) {
        return CharSequenceHandle.startWith(str, prefix, false);
    }

    public static boolean startWithAny(CharSequence str, CharSequence ... prefixes) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence prefix : prefixes) {
            if (!CharSequenceHandle.startWith(str, prefix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWithAnyIgnoreCase(CharSequence str, CharSequence ... prefixes) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(prefixes)) {
            return false;
        }
        for (CharSequence prefix : prefixes) {
            if (!CharSequenceHandle.startWith(str, prefix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        return CharSequenceHandle.startWith(str, prefix, ignoreCase, false);
    }

    public static boolean startWith(CharSequence str, CharSequence prefix, boolean ignoreCase, boolean ignoreEquals) {
        return new StringRegionMatcher(ignoreCase, ignoreEquals, true).test(str, prefix);
    }

    public static boolean endWith(CharSequence str, char c) {
        if (CharSequenceHandle.isEmpty(str)) {
            return false;
        }
        return c == str.charAt(str.length() - 1);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix) {
        return CharSequenceHandle.endWith(str, suffix, false);
    }

    public static boolean endWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return CharSequenceHandle.endWith(str, suffix, true);
    }

    public static boolean endWithAny(CharSequence str, CharSequence ... suffixes) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceHandle.endWith(str, suffix, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWithAnyIgnoreCase(CharSequence str, CharSequence ... suffixes) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(suffixes)) {
            return false;
        }
        for (CharSequence suffix : suffixes) {
            if (!CharSequenceHandle.endWith(str, suffix, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        return CharSequenceHandle.endWith(str, suffix, ignoreCase, false);
    }

    public static boolean endWith(CharSequence str, CharSequence suffix, boolean ignoreCase, boolean ignoreEquals) {
        return new StringRegionMatcher(ignoreCase, ignoreEquals, false).test(str, suffix);
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return CharSequenceHandle.indexOf(str, searchChar) > -1;
    }

    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (null == str || null == searchStr) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceHandle.getContainsStr(str, testStrs);
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (CharSequenceHandle.isNotEmpty(str)) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!RsArray.contains(testChars, str.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsBlank(CharSequence str) {
        if (null == str) {
            return false;
        }
        int length = str.length();
        if (0 == length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (!RsChar.isBlankChar(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence checkStr : testStrs) {
            if (!CharSequenceHandle.contains(str, checkStr)) continue;
            return checkStr.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return CharSequenceHandle.indexOf(str, testStr, 0, true) > -1;
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != CharSequenceHandle.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(testStrs)) {
            return null;
        }
        for (CharSequence testStr : testStrs) {
            if (!CharSequenceHandle.containsIgnoreCase(str, testStr)) continue;
            return testStr.toString();
        }
        return null;
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return CharSequenceHandle.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        if (str instanceof String) {
            return ((String)str).indexOf(searchChar, start);
        }
        return CharSequenceHandle.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence text, char searchChar, int start, int end) {
        if (CharSequenceHandle.isEmpty(text)) {
            return -1;
        }
        return new CharFinder(searchChar).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOf(CharSequence text, Predicate<Character> matcher, int start, int end) {
        if (CharSequenceHandle.isEmpty(text)) {
            return -1;
        }
        return new CharMatcherFinder(matcher).setText(text).setEndIndex(end).start(start);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return CharSequenceHandle.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return CharSequenceHandle.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence text, CharSequence searchStr, int from, boolean ignoreCase) {
        if (CharSequenceHandle.isEmpty(text) || CharSequenceHandle.isEmpty(searchStr)) {
            if (CharSequenceHandle.equals(text, searchStr)) {
                return 0;
            }
            return -1;
        }
        return StringFinder.of(searchStr, ignoreCase).setText(text).start(from);
    }

    public static String removeAll(CharSequence str, char ... chars) {
        if (RsString.isEmpty(str) || RsArray.isEmpty(chars)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        return CharSequenceHandle.filter(str, c -> !RsArray.contains(chars, c.charValue()));
    }

    public static String removePreAndLowerFirst(CharSequence str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.toString().substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str.toString();
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        return CharSequenceHandle.removePrefix(str, prefix, false);
    }

    public static String removePrefix(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        if (CharSequenceHandle.isEmpty(str) || CharSequenceHandle.isEmpty(prefix)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        String str2 = str.toString();
        if (CharSequenceHandle.startWith(str, prefix, ignoreCase)) {
            return CharSequenceHandle.subSuf(str2, prefix.length());
        }
        return str2;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (CharSequenceHandle.isEmpty(str) || CharSequenceHandle.isEmpty(suffix)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        String str2 = str.toString();
        if (str2.endsWith(suffix.toString())) {
            return CharSequenceHandle.subPre(str2, str2.length() - suffix.length());
        }
        return str2;
    }

    public static String cleanBlank(CharSequence str) {
        return CharSequenceHandle.filter(str, c -> !RsChar.isBlankChar(c.charValue()));
    }

    public static String addPrefixIfNot(CharSequence str, CharSequence prefix) {
        return CharSequenceHandle.prependIfMissing(str, prefix, prefix);
    }

    public static String addSuffixIfNot(CharSequence str, CharSequence suffix) {
        return CharSequenceHandle.appendIfMissing(str, suffix, new CharSequence[0]);
    }

    public static String sub(CharSequence str, int fromIndexInclude, int toIndexExclude) {
        if (CharSequenceHandle.isEmpty(str)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return "";
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    public static String subPre(CharSequence string, int toIndexExclude) {
        if (CharSequenceHandle.isEmpty(string) || string.length() == toIndexExclude) {
            return CharSequenceHandle.toStringOrNull(string);
        }
        return CharSequenceHandle.sub(string, 0, toIndexExclude);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        if (0 == fromIndex || CharSequenceHandle.isEmpty(string)) {
            return CharSequenceHandle.toStringOrNull(string);
        }
        return CharSequenceHandle.sub(string, fromIndex, string.length());
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string) || separator == null) {
            return null == string ? null : string.toString();
        }
        String str = string.toString();
        String sep = separator.toString();
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subBefore(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string)) {
            return null == string ? null : "";
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string)) {
            return null == string ? null : "";
        }
        if (separator == null) {
            return "";
        }
        String str = string.toString();
        String sep = separator.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos || string.length() - 1 == pos) {
            return "";
        }
        return str.substring(pos + separator.length());
    }

    public static String subAfter(CharSequence string, char separator, boolean isLastSeparator) {
        int pos;
        if (CharSequenceHandle.isEmpty(string)) {
            return null == string ? null : "";
        }
        String str = string.toString();
        int n = pos = isLastSeparator ? str.lastIndexOf(separator) : str.indexOf(separator);
        if (-1 == pos) {
            return "";
        }
        return str.substring(pos + 1);
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        int end;
        if (str == null || before == null || after == null) {
            return null;
        }
        String str2 = str.toString();
        String before2 = before.toString();
        String after2 = after.toString();
        int start = str2.indexOf(before2);
        if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
            return str2.substring(start + before2.length(), end);
        }
        return null;
    }

    public static String repeat(char c, int count) {
        if (count <= 0) {
            return "";
        }
        return StringRepeater.of(count).repeat(c);
    }

    public static String repeatAndJoin(CharSequence str, int count, CharSequence delimiter) {
        if (count <= 0) {
            return "";
        }
        return StringRepeater.of(count).repeatAndJoin(str, delimiter);
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return CharSequenceHandle.equals(str1, str2, false);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        if (ignoreCase) {
            return str1.toString().equalsIgnoreCase(str2.toString());
        }
        return str1.toString().contentEquals(str2);
    }

    public static boolean isSubEquals(CharSequence str1, int offset1, CharSequence str2, int offset2, int length, boolean ignoreCase) {
        if (null == str1 || null == str2) {
            return false;
        }
        return str1.toString().regionMatches(ignoreCase, offset1, str2.toString(), offset2, length);
    }

    public static String format(CharSequence template, Object ... params) {
        if (null == template) {
            return "null";
        }
        if (RsArray.isEmpty(params) || CharSequenceHandle.isBlank(template)) {
            return template.toString();
        }
        return StringFormatter.format(template.toString(), params);
    }

    public static String unWrap(CharSequence str, char prefix, char suffix) {
        if (CharSequenceHandle.isEmpty(str)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        if (str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix) {
            return CharSequenceHandle.sub(str, 1, str.length() - 1);
        }
        return str.toString();
    }

    public static String unWrap(CharSequence str, char prefixAndSuffix) {
        return CharSequenceHandle.unWrap(str, prefixAndSuffix, prefixAndSuffix);
    }

    public static boolean isWrap(CharSequence str, char prefixChar, char suffixChar) {
        if (null == str || str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (CharSequenceHandle.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, CharSequence ... suffixes) {
        return CharSequenceHandle.appendIfMissing(str, suffix, false, suffixes);
    }

    public static String appendIfMissing(CharSequence str, CharSequence suffix, boolean ignoreCase, CharSequence ... testSuffixes) {
        if (str == null || CharSequenceHandle.isEmpty(suffix) || CharSequenceHandle.endWith(str, suffix, ignoreCase)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        if (RsArray.isNotEmpty(testSuffixes)) {
            for (CharSequence testSuffix : testSuffixes) {
                if (!CharSequenceHandle.endWith(str, testSuffix, ignoreCase)) continue;
                return str.toString();
            }
        }
        return str.toString().concat(suffix.toString());
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, CharSequence ... prefixes) {
        return CharSequenceHandle.prependIfMissing(str, prefix, false, prefixes);
    }

    public static String prependIfMissing(CharSequence str, CharSequence prefix, boolean ignoreCase, CharSequence ... prefixes) {
        if (str == null || CharSequenceHandle.isEmpty(prefix) || CharSequenceHandle.startWith(str, prefix, ignoreCase)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        if (RsArray.isNotEmpty(prefixes)) {
            for (CharSequence s : prefixes) {
                if (!CharSequenceHandle.startWith(str, s, ignoreCase)) continue;
                return str.toString();
            }
        }
        return prefix.toString().concat(str.toString());
    }

    public static String replace(CharSequence str, CharSequence searchStr, CharSequence replacement) {
        return CharSequenceHandle.replace(str, 0, searchStr, replacement, false);
    }

    public static String replace(CharSequence str, int fromIndex, CharSequence searchStr, CharSequence replacement, boolean ignoreCase) {
        if (CharSequenceHandle.isEmpty(str) || CharSequenceHandle.isEmpty(searchStr)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        return new SearchReplacer(fromIndex, searchStr, replacement, ignoreCase).apply(str);
    }

    public static String replaceByCodePoint(CharSequence str, int beginInclude, int endExclude, char replacedChar) {
        return new RangeReplacerByChar(beginInclude, endExclude, replacedChar, true).apply(str);
    }

    public static String hide(CharSequence str, int startInclude, int endExclude) {
        return CharSequenceHandle.replaceByCodePoint(str, startInclude, endExclude, '*');
    }

    public static String replaceChars(CharSequence str, String chars, CharSequence replacedStr) {
        if (CharSequenceHandle.isEmpty(str) || CharSequenceHandle.isEmpty(chars)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        return CharSequenceHandle.replaceChars(str, chars.toCharArray(), replacedStr);
    }

    public static String replaceChars(CharSequence str, char[] chars, CharSequence replacedStr) {
        if (CharSequenceHandle.isEmpty(str) || RsArray.isEmpty(chars)) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        HashSet<Character> set = new HashSet<Character>(chars.length);
        for (char c : chars) {
            set.add(Character.valueOf(c));
        }
        int strLen = str.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            builder.append(set.contains(Character.valueOf(c)) ? replacedStr : Character.valueOf(c));
        }
        return builder.toString();
    }

    public static String replaceAt(CharSequence str, int index, UnaryOperator<Character> operator) {
        Character newC;
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (index < 0) {
            index += length;
        }
        String string = str.toString();
        if (index < 0 || index >= length) {
            return string;
        }
        char c = string.charAt(index);
        if (c == (newC = (Character)operator.apply(Character.valueOf(c))).charValue()) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[index] = newC.charValue();
        return new String(chars);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static int codeLength(CharSequence cs) {
        return cs == null ? 0 : cs.toString().codePointCount(0, cs.length());
    }

    public static String upperFirstAndAddPre(CharSequence str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + CharSequenceHandle.upperFirst(str);
    }

    public static String upperFirst(CharSequence str) {
        return CharSequenceHandle.upperAt(str, 0);
    }

    public static String upperAt(CharSequence str, int index) {
        return CharSequenceHandle.replaceAt(str, index, Character::toUpperCase);
    }

    public static String lowerFirst(CharSequence str) {
        return CharSequenceHandle.lowerAt(str, 0);
    }

    public static String lowerAt(CharSequence str, int index) {
        return CharSequenceHandle.replaceAt(str, index, Character::toLowerCase);
    }

    public static String filter(CharSequence str, Predicate<Character> predicate) {
        if (str == null || predicate == null) {
            return CharSequenceHandle.toStringOrNull(str);
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (!predicate.test(Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isUpperCase(CharSequence str) {
        return NamingCase.isUpperCase(str);
    }

    public static String toUnderlineCase(CharSequence str) {
        return NamingCase.toUnderlineCase(str);
    }

    public static String toCamelCase(CharSequence name) {
        return NamingCase.toCamelCase(name);
    }

    public static int[] toChars(CharSequence str, boolean isCodePoint) {
        if (null == str) {
            return null;
        }
        return (isCodePoint ? str.codePoints() : str.chars()).toArray();
    }

    public static int indexOf(CharSequence str, CharSequence searchStr) {
        return CharSequenceHandle.indexOf(str, searchStr, 0);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex) {
        return CharSequenceHandle.indexOf(str, searchStr, fromIndex, false);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, boolean ignoreCase) {
        return CharSequenceHandle.indexOf(str, searchStr, 0, ignoreCase);
    }
}

