/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.regex;

import java.util.regex.Pattern;
import top.redscorpion.core.map.reference.WeakConcurrentMap;

public class PatternPool {
    public static final Pattern NUMBERS = Pattern.compile("\\d+");
    public static final Pattern GROUP_VAR = Pattern.compile("\\$(\\d+)");
    public static final Pattern EMAIL = Pattern.compile("(?:[a-z0-9\\u4e00-\\u9fa5!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9\\u4e00-\\u9fa5!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9\\u4e00-\\u9fa5](?:[a-z0-9\\u4e00-\\u9fa5-]*[a-z0-9\\u4e00-\\u9fa5])?\\.)+[a-z0-9\\u4e00-\\u9fa5](?:[a-z0-9\\u4e00-\\u9fa5-]*[a-z0-9\\u4e00-\\u9fa5])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9\\u4e00-\\u9fa5-]*[a-z0-9\\u4e00-\\u9fa5]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])", 2);
    public static final Pattern MOBILE = Pattern.compile("(?:0|86|\\+86)?1[3-9]\\d{9}");
    public static final Pattern BIRTHDAY = Pattern.compile("^(\\d{2,4})([/\\-.\u5e74]?)(\\d{1,2})([/\\-.\u6708]?)(\\d{1,2})\u65e5?$");
    public static final Pattern HEX = Pattern.compile("^[a-fA-F0-9]+$");
    public static final Pattern TIME = Pattern.compile("\\d{1,2}[:\u65f6]\\d{1,2}([:\u5206]\\d{1,2})?\u79d2?");
    private static final WeakConcurrentMap<RegexWithFlag, Pattern> POOL = new WeakConcurrentMap();

    public static Pattern get(String regex, int flags) {
        RegexWithFlag regexWithFlag = new RegexWithFlag(regex, flags);
        return POOL.computeIfAbsent(regexWithFlag, key -> Pattern.compile(regex, flags));
    }

    private static class RegexWithFlag {
        private final String regex;
        private final int flag;

        public RegexWithFlag(String regex, int flag) {
            this.regex = regex;
            this.flag = flag;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.flag;
            result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegexWithFlag other = (RegexWithFlag)obj;
            if (this.flag != other.flag) {
                return false;
            }
            if (this.regex == null) {
                return other.regex == null;
            }
            return this.regex.equals(other.regex);
        }
    }
}

