/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.reflect.Invoker;
import top.redscorpion.core.reflect.method.RsMethod;
import top.redscorpion.core.reflect.method.RsMethodHandle;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsModifier;

public class MethodInvoker
implements Invoker {
    private final Method method;
    private final Class<?>[] paramTypes;
    private final Class<?> type;
    private boolean checkArgs;

    public static MethodInvoker of(Method method) {
        return new MethodInvoker(method);
    }

    public MethodInvoker(Method method) {
        this.method = method;
        this.paramTypes = method.getParameterTypes();
        this.type = this.paramTypes.length == 1 ? this.paramTypes[0] : method.getReturnType();
    }

    public MethodInvoker setCheckArgs(boolean checkArgs) {
        this.checkArgs = checkArgs;
        return this;
    }

    @Override
    public <T> T invoke(Object target, Object ... args) throws RsException {
        Method method;
        if (this.checkArgs) {
            this.checkArgs(args);
        }
        if (RsModifier.isStatic(method = this.method)) {
            target = null;
        }
        Object[] actualArgs = RsMethod.actualArgs(method, args);
        try {
            return RsMethodHandle.invokeExact(target, method, actualArgs);
        }
        catch (Exception e) {
            try {
                return (T)method.invoke(target, actualArgs);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RsException(ex);
            }
        }
    }

    public <T> T invokeStatic(Object ... args) throws RsException {
        return this.invoke(null, args);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    private void checkArgs(Object[] args) {
        Class<?>[] paramTypes = this.paramTypes;
        if (null != args) {
            Assert.isTrue(args.length == paramTypes.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, paramTypes.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = paramTypes[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = RsClass.getDefaultValue(type);
            }
        }
    }
}

