/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect.lookup;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.reflect.RsConstructor;
import top.redscorpion.core.reflect.lookup.ConstructorLookupFactory;
import top.redscorpion.core.reflect.lookup.LookupFactory;
import top.redscorpion.core.reflect.lookup.MethodLookupFactory;
import top.redscorpion.core.util.RsCaller;
import top.redscorpion.core.util.RsJdk;
import top.redscorpion.core.util.RsModifier;

public class RsLookup {
    private static final LookupFactory FACTORY = RsJdk.IS_JDK8 ? new ConstructorLookupFactory() : new MethodLookupFactory();

    public static MethodHandles.Lookup lookup() {
        return RsLookup.lookup(RsCaller.getCaller());
    }

    public static MethodHandles.Lookup lookup(Class<?> callerClass) {
        return FACTORY.lookup(callerClass);
    }

    public static MethodHandle unreflect(Member methodOrConstructor) throws RsException {
        try {
            if (methodOrConstructor instanceof Method) {
                return RsLookup.unreflectMethod((Method)methodOrConstructor);
            }
            return RsLookup.lookup().unreflectConstructor((Constructor)methodOrConstructor);
        }
        catch (IllegalAccessException e) {
            throw new RsException(e);
        }
    }

    public static MethodHandle unreflectMethod(Method method) throws IllegalAccessException {
        Class<?> caller = method.getDeclaringClass();
        MethodHandles.Lookup lookup = RsLookup.lookup(caller);
        if (RsModifier.isDefault(method)) {
            return lookup.unreflectSpecial(method, caller);
        }
        try {
            return lookup.unreflect(method);
        }
        catch (Exception ignore) {
            return lookup.unreflectSpecial(method, caller);
        }
    }

    public static MethodHandle findConstructor(Class<?> callerClass, Class<?> ... argTypes) {
        Constructor<?> constructor = RsConstructor.getConstructor(callerClass, argTypes);
        if (null != constructor) {
            return RsLookup.unreflect(constructor);
        }
        return null;
    }
}

