/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.reflect;

import java.lang.reflect.Field;
import java.util.function.Predicate;
import top.redscorpion.core.annotation.Alias;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.map.reference.WeakConcurrentMap;
import top.redscorpion.core.reflect.FieldReflect;
import top.redscorpion.core.util.RsArray;
import top.redscorpion.core.util.RsClass;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsReflect;
import top.redscorpion.core.util.RsString;

public class RsField {
    private static final WeakConcurrentMap<Class<?>, FieldReflect> FIELDS_CACHE = new WeakConcurrentMap();

    static synchronized void clearCache() {
        FIELDS_CACHE.clear();
    }

    public static boolean isOuterClassField(Field field) {
        return "this$0".equals(field.getName());
    }

    public static String getFieldName(Field field) {
        return RsField.getFieldName(field, true);
    }

    public static String getFieldName(Field field, boolean useAlias) {
        Alias alias;
        if (null == field) {
            return null;
        }
        if (useAlias && null != (alias = field.getAnnotation(Alias.class))) {
            return alias.value();
        }
        return field.getName();
    }

    public static Field getDeclearField(Class<?> beanClass, String name) {
        Field[] fields = RsField.getDeclaredFields(beanClass, field -> RsString.equals(name, field.getName()));
        return RsArray.isEmpty(fields) ? null : fields[0];
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = RsField.getFields(beanClass, field -> RsString.equals(name, field.getName()));
        return RsArray.isEmpty(fields) ? null : fields[0];
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        return RsField.getFields(beanClass, null);
    }

    public static Field[] getFields(Class<?> beanClass, Predicate<Field> fieldPredicate) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, FieldReflect::of).getAllFields(fieldPredicate);
    }

    public static Field[] getDeclaredFields(Class<?> beanClass, Predicate<Field> fieldPredicate) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, FieldReflect::of).getDeclaredFields(fieldPredicate);
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        return FieldReflect.of(beanClass).getFieldsDirectly(withSuperClassFields);
    }

    public static Object getFieldValue(Object obj, String fieldName) throws RsException {
        if (null == obj || RsString.isBlank(fieldName)) {
            return null;
        }
        return RsField.getFieldValue(obj, RsField.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName));
    }

    public static Object getStaticFieldValue(Field field) throws RsException {
        return RsField.getFieldValue(null, field);
    }

    public static Object getFieldValue(Object obj, Field field) throws RsException {
        Object result;
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        RsReflect.setAccessible(field);
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RsException(e, "IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws RsException {
        Assert.notNull(obj, "Object must be not null !", new Object[0]);
        Assert.notBlank(fieldName);
        Field field = RsField.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, obj.getClass().getName());
        RsField.setFieldValue(obj, field, value);
    }

    public static void setStaticFieldValue(Field field, Object value) throws RsException {
        RsField.setFieldValue(null, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws RsException {
        Assert.notNull(field, "Field in [{}] not exist !", obj);
        Class<?> fieldType = field.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = RsConvert.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = RsClass.getDefaultValue(fieldType);
        }
        RsField.setFieldValueExact(obj, field, value);
    }

    public static void setFieldValueExact(Object obj, Field field, Object value) throws RsException {
        RsReflect.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RsException(e, "IllegalAccess for [{}.{}]", null == obj ? field.getDeclaringClass() : obj, field.getName());
        }
    }
}

