/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.net.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import top.redscorpion.core.map.multi.ListValueMap;
import top.redscorpion.core.map.multi.MultiValueMap;
import top.redscorpion.core.net.multipart.MultipartRequestInputStream;
import top.redscorpion.core.net.multipart.UploadFile;
import top.redscorpion.core.net.multipart.UploadFileHeader;
import top.redscorpion.core.net.multipart.UploadSetting;

public class MultipartFormData {
    private final MultiValueMap<String, String> requestParameters = new ListValueMap<String, String>();
    private final MultiValueMap<String, UploadFile> requestFiles = new ListValueMap<String, UploadFile>();
    private final UploadSetting setting;
    private boolean loaded;

    public MultipartFormData(UploadSetting uploadSetting) {
        this.setting = uploadSetting == null ? new UploadSetting() : uploadSetting;
    }

    public void parseRequestStream(InputStream inputStream, Charset charset) throws IOException {
        UploadFileHeader header;
        this.setLoaded();
        MultipartRequestInputStream input = new MultipartRequestInputStream(inputStream);
        input.readBoundary();
        while ((header = input.readDataHeader(charset)) != null) {
            if (header.isFile) {
                UploadFile newFile;
                String fileName = header.fileName;
                if (!fileName.isEmpty() && header.contentType.contains("application/x-macbinary")) {
                    input.skipBytes(128L);
                }
                if ((newFile = new UploadFile(header, this.setting)).processStream(input)) {
                    this.putFile(header.formFieldName, newFile);
                }
            } else {
                this.putParameter(header.formFieldName, input.readString(charset));
            }
            input.skipBytes(1L);
            input.mark(1);
            int nextByte = input.read();
            if (nextByte == -1 || nextByte == 45) {
                input.reset();
                break;
            }
            input.reset();
        }
    }

    public MultiValueMap<String, String> getParamListMap() {
        return this.requestParameters;
    }

    private void putFile(String name, UploadFile uploadFile) {
        this.requestFiles.putValue(name, uploadFile);
    }

    private void putParameter(String name, String value) {
        this.requestParameters.putValue(name, value);
    }

    private void setLoaded() throws IOException {
        if (this.loaded) {
            throw new IOException("Multi-part request already parsed.");
        }
        this.loaded = true;
    }
}

