/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format.parser;

import java.io.Serializable;
import top.redscorpion.core.date.DatePattern;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.date.format.parser.PredicateDateParser;
import top.redscorpion.core.regex.PatternPool;
import top.redscorpion.core.util.RsDate;
import top.redscorpion.core.util.RsRegular;
import top.redscorpion.core.util.RsString;

public class TimeParser
implements PredicateDateParser,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final TimeParser INSTANCE = new TimeParser();

    @Override
    public boolean test(CharSequence dateStr) {
        return RsRegular.isMatch(PatternPool.TIME, dateStr);
    }

    @Override
    public DateTime parse(CharSequence source) {
        source = RsString.replaceChars(source, "\u65f6\u5206\u79d2", (CharSequence)":");
        source = RsString.format("{} {}", RsDate.formatDate(new DateTime()), source);
        if (1 == RsString.count(source, ':')) {
            return new DateTime(source, "yyyy-MM-dd HH:mm");
        }
        return new DateTime(source, DatePattern.NORM_DATETIME_FORMAT);
    }
}

