/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.date.format;

import java.text.Format;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import top.redscorpion.core.lang.Assert;
import top.redscorpion.core.lang.tuple.Tuple;
import top.redscorpion.core.map.concurrent.SafeConcurrentHashMap;

abstract class AbstractFormatCache<F extends Format> {
    private final ConcurrentMap<Tuple, F> cInstanceCache = new SafeConcurrentHashMap<Tuple, F>(7);

    AbstractFormatCache() {
    }

    public F getInstance(String pattern, TimeZone timeZone, Locale locale) {
        Format previousValue;
        Tuple key;
        Format format;
        Assert.notBlank(pattern, "pattern must not be blank", new Object[0]);
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((format = (Format)this.cInstanceCache.get(key = new Tuple(pattern, timeZone, locale))) == null && (previousValue = this.cInstanceCache.putIfAbsent(key, format = this.createInstance(pattern, timeZone, locale))) != null) {
            format = previousValue;
        }
        return (F)format;
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);
}

