/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.data.id;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Random;
import top.redscorpion.core.codec.Number128;
import top.redscorpion.core.util.RsRandom;

public class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = -1185015143654744140L;
    private final Number128 idValue;

    private UUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.idValue = new Number128(msb, lsb);
    }

    public static UUID fastUuid() {
        return UUID.randomUuid(false);
    }

    public static UUID randomUuid() {
        return UUID.randomUuid(true);
    }

    public static UUID randomUuid(boolean isSecure) {
        return UUID.randomUUID(isSecure ? Holder.NUMBER_GENERATOR : RsRandom.getRandom());
    }

    public static UUID randomUUID(Random random) {
        byte[] randomBytes = RsRandom.randomBytes(16, random);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0xFFFFFF80);
        return new UUID(randomBytes);
    }

    public long getLeastSignificantBits() {
        return this.idValue.getLeastSigBits();
    }

    public long getMostSignificantBits() {
        return this.idValue.getMostSigBits();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean isSimple) {
        long mostSigBits = this.getLeastSignificantBits();
        long leastSigBits = this.getLeastSignificantBits();
        StringBuilder builder = new StringBuilder(isSimple ? 32 : 36);
        builder.append(UUID.digits(mostSigBits >> 32, 8));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(mostSigBits >> 16, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(mostSigBits, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(leastSigBits >> 48, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(leastSigBits, 12));
        return builder.toString();
    }

    public int hashCode() {
        long hilo = this.getLeastSignificantBits() ^ this.getMostSignificantBits();
        return (int)(hilo >> 32) ^ (int)hilo;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != UUID.class) {
            return false;
        }
        UUID id = (UUID)obj;
        long mostSigBits = this.getLeastSignificantBits();
        long leastSigBits = this.getLeastSignificantBits();
        return mostSigBits == id.getMostSignificantBits() && leastSigBits == id.getLeastSignificantBits();
    }

    @Override
    public int compareTo(UUID val) {
        int compare = Long.compare(this.getMostSignificantBits(), val.getMostSignificantBits());
        if (0 == compare) {
            compare = Long.compare(this.getLeastSignificantBits(), val.getLeastSignificantBits());
        }
        return compare;
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    private static class Holder {
        static final SecureRandom NUMBER_GENERATOR = RsRandom.getSecureRandom();

        private Holder() {
        }
    }
}

