/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.util.function.Function;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.convert.impl.NumberConverter;
import top.redscorpion.core.util.RsConvert;
import top.redscorpion.core.util.RsObject;
import top.redscorpion.core.util.RsString;

public class PrimitiveConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final PrimitiveConverter INSTANCE = new PrimitiveConverter();

    @Override
    protected Object convertInternal(Class<?> targetClass, Object value) {
        return PrimitiveConverter.convert(value, targetClass, this::convertToStr);
    }

    @Override
    protected String convertToStr(Object value) {
        return RsString.trim(super.convertToStr(value));
    }

    protected static Object convert(Object value, Class<?> primitiveClass, Function<Object, String> toStringFunc) {
        if (Byte.TYPE == primitiveClass) {
            return RsObject.defaultIfNull(NumberConverter.convert(value, Byte.class, toStringFunc), 0);
        }
        if (Short.TYPE == primitiveClass) {
            return RsObject.defaultIfNull(NumberConverter.convert(value, Short.class, toStringFunc), 0);
        }
        if (Integer.TYPE == primitiveClass) {
            return RsObject.defaultIfNull(NumberConverter.convert(value, Integer.class, toStringFunc), 0);
        }
        if (Long.TYPE == primitiveClass) {
            return RsObject.defaultIfNull(NumberConverter.convert(value, Long.class, toStringFunc), 0);
        }
        if (Float.TYPE == primitiveClass) {
            return RsObject.defaultIfNull(NumberConverter.convert(value, Float.class, toStringFunc), 0);
        }
        if (Double.TYPE == primitiveClass) {
            return RsObject.defaultIfNull(NumberConverter.convert(value, Double.class, toStringFunc), 0);
        }
        if (Character.TYPE == primitiveClass) {
            return RsConvert.convert(Character.class, value);
        }
        if (Boolean.TYPE == primitiveClass) {
            return RsConvert.convert(Boolean.class, value);
        }
        throw new ConvertException("Unsupported target type: {}", primitiveClass);
    }
}

