/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.core.convert.impl;

import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import top.redscorpion.core.convert.AbstractConverter;
import top.redscorpion.core.convert.ConvertException;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.util.RsDate;
import top.redscorpion.core.util.RsSqlDate;
import top.redscorpion.core.util.RsString;

public class DateConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final DateConverter INSTANCE = new DateConverter();
    private String format;

    public DateConverter() {
        this(null);
    }

    public DateConverter(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Class<?> targetClass, Object value) {
        DateTime date;
        if (value == null || value instanceof CharSequence && RsString.isBlank(value.toString())) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return this.wrap(targetClass, RsDate.date((TemporalAccessor)value));
        }
        if (value instanceof Calendar) {
            return this.wrap(targetClass, RsDate.date((Calendar)value));
        }
        if (null == this.format && value instanceof Number) {
            return this.wrap(targetClass, ((Number)value).longValue());
        }
        String valueStr = this.convertToStr(value);
        DateTime dateTime = date = RsString.isBlank(this.format) ? RsDate.parse(valueStr) : RsDate.parse((CharSequence)valueStr, this.format);
        if (null != date) {
            return this.wrap(targetClass, date);
        }
        throw new ConvertException("Can not convert {}:[{}] to {}", value.getClass().getName(), value, targetClass.getName());
    }

    private Date wrap(Class<?> targetClass, Date date) {
        if (targetClass == date.getClass()) {
            return date;
        }
        return this.wrap(targetClass, date.getTime());
    }

    private Date wrap(Class<?> targetClass, long mills) {
        if (Date.class == targetClass) {
            return new Date(mills);
        }
        if (DateTime.class == targetClass) {
            return RsDate.date(mills);
        }
        String dateClassName = targetClass.getName();
        if (dateClassName.startsWith("java.sql.")) {
            return RsSqlDate.wrap(targetClass, mills);
        }
        throw new ConvertException("Unsupported target Date type: {}", new Object[]{targetClass.getName()});
    }
}

